/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.policy.wtp.editor.util;

import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.internal.EditorSite;
import org.eclipse.ui.internal.LayoutPart;
import org.eclipse.ui.internal.PartPane;
import org.eclipse.ui.internal.PartSite;
import org.eclipse.ui.internal.PartStack;
import org.eclipse.ui.internal.ViewSite;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.dnd.DragUtil;
import org.eclipse.ui.internal.dnd.TestDropLocation;

public class DragOperations {
    public static void drag(IWorkbenchPart part, TestDropLocation target, boolean wholeFolder) {
        DragUtil.forceDropLocation((TestDropLocation)target);
        PartSite site = (PartSite)part.getSite();
        PartPane pane = site.getPane();
        PartStack parent = (PartStack)pane.getContainer();
        parent.paneDragStart((LayoutPart)(wholeFolder ? null : pane), Display.getDefault().getCursorLocation(), false);
        DragUtil.forceDropLocation(null);
    }

    public static String getName(IEditorPart editor) {
        PartPane pane = ((EditorSite)editor.getSite()).getPane();
        IWorkbenchPartReference ref = pane.getPartReference();
        return ref.getPartName();
    }

    public static PartPane getPane(IEditorPart editor) {
        return ((EditorSite)editor.getSite()).getPane();
    }

    public static PartPane getPane(IViewPart view) {
        return ((ViewSite)view.getSite()).getPane();
    }

    public static Rectangle getDisplayBounds(PartPane pane) {
        LayoutPart parent = (LayoutPart)pane.getContainer();
        Rectangle bounds = DragUtil.getDisplayBounds((Control)parent.getControl());
        return bounds;
    }

    public static Point getLocation(PartPane pane, int side) {
        return DragOperations.getPoint(DragOperations.getDisplayBounds(pane), side);
    }

    public static Point getPointInEditorArea(WorkbenchPage page, int side) {
        return DragOperations.getPoint(DragUtil.getDisplayBounds((Control)page.getEditorPresentation().getLayoutPart().getControl()), side);
    }

    public static Point getPoint(Rectangle bounds, int side) {
        Point centerPoint = Geometry.centerPoint((Rectangle)bounds);
        switch (side) {
            case 128: {
                return new Point(centerPoint.x, bounds.y + 1);
            }
            case 1024: {
                return new Point(centerPoint.x, bounds.y + bounds.height - 1);
            }
            case 16384: {
                return new Point(bounds.x + 1, centerPoint.y);
            }
            case 131072: {
                return new Point(bounds.x + bounds.width - 1, centerPoint.y);
            }
        }
        return centerPoint;
    }

    public static String nameForConstant(int swtSideConstant) {
        switch (swtSideConstant) {
            case 128: {
                return "top";
            }
            case 1024: {
                return "bottom";
            }
            case 16384: {
                return "left";
            }
            case 131072: {
                return "right";
            }
        }
        return "center";
    }

    public static String getName(IViewPart targetPart) {
        return targetPart.getTitle();
    }

    public static String getLayoutDescription(WorkbenchPage page) {
        StringBuffer buf = new StringBuffer();
        page.getActivePerspective().describeLayout(buf);
        return buf.toString();
    }
}

