/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.common.java.classloader;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.stp.sca.common.classloader.ScaClassLoader;
import org.eclipse.stp.sca.common.java.ScaCommonJdtPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScaJdtClassLoader
extends ScaClassLoader {
    public ScaJdtClassLoader(IJavaProject javaProject, ClassLoader parent) {
        super(ScaJdtClassLoader.getJavaProjectClasspath(javaProject), parent);
    }

    public static URL[] getJavaProjectClasspath(IJavaProject javaProject) {
        Set<String> urlsAsString = ScaJdtClassLoader.getJavaProjectClassPath(javaProject);
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String uas : urlsAsString) {
            Status status;
            try {
                URL url = new URI(uas).toURL();
                urls.add(url);
            }
            catch (MalformedURLException e) {
                status = new Status(4, "org.eclipse.stp.sca.common.java", e.getMessage(), (Throwable)e);
                ScaCommonJdtPlugin.getDefault().getLog().log((IStatus)status);
            }
            catch (URISyntaxException e) {
                status = new Status(4, "org.eclipse.stp.sca.common.java", e.getMessage(), (Throwable)e);
                ScaCommonJdtPlugin.getDefault().getLog().log((IStatus)status);
            }
        }
        URL[] result = new URL[urls.size()];
        return urls.toArray(result);
    }

    private static Set<String> getJavaProjectClassPath(IJavaProject javaProject) {
        HashSet<String> urlList = new HashSet<String>();
        try {
            String projectLocation = javaProject.getProject().getLocationURI().toString();
            String binLocation = String.valueOf(javaProject.getOutputLocation().toString().replace(String.valueOf(javaProject.getProject().getName()) + "/", "")) + "/";
            urlList.add(String.valueOf(projectLocation) + binLocation);
            Object[] objectArray = javaProject.getResolvedClasspath(false);
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry cpEntry = objectArray[n2];
                urlList.add("file:/" + cpEntry.getPath().toString().replace(" ", "%20"));
                ++n2;
            }
            objectArray = javaProject.getRequiredProjectNames();
            n = objectArray.length;
            n2 = 0;
            while (n2 < n) {
                IClasspathEntry jpName = objectArray[n2];
                IProject p = ResourcesPlugin.getWorkspace().getRoot().getProject((String)jpName);
                IJavaProject jp = JavaCore.create((IProject)p);
                Set<String> jpUrls = ScaJdtClassLoader.getJavaProjectClassPath(jp);
                urlList.addAll(jpUrls);
                ++n2;
            }
        }
        catch (JavaModelException e) {
            Status status = new Status(4, "org.eclipse.stp.sca.common.java", e.getMessage(), (Throwable)e);
            ScaCommonJdtPlugin.getDefault().getLog().log((IStatus)status);
        }
        return urlList;
    }
}

