/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.common.java.extensions;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.stp.sca.common.internal.provisional.filters.ScaAbstractResourcesFilter;
import org.eclipse.stp.sca.common.java.utils.JDTUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScaJavaResourcesFilter
extends ScaAbstractResourcesFilter<IJavaProject> {
    public IJavaProject getProject(IProject project) {
        return JDTUtils.getJavaProject(project);
    }

    public Set<IFolder> getBinaryFolders(IProject project) {
        HashSet<IFolder> binaryFolders = new HashSet<IFolder>();
        IJavaProject jp = this.getProject(project);
        if (jp == null) {
            return binaryFolders;
        }
        try {
            IFolder folder;
            IPath outputPath = jp.getOutputLocation();
            if (outputPath != null && (folder = ResourcesPlugin.getWorkspace().getRoot().getFolder(outputPath)).exists()) {
                binaryFolders.add(folder);
            }
            IClasspathEntry[] iClasspathEntryArray = jp.getRawClasspath();
            int n = iClasspathEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                IFolder folder2;
                IClasspathEntry entry = iClasspathEntryArray[n2];
                if (entry.getEntryKind() == 3 && (outputPath = entry.getOutputLocation()) != null && (folder2 = ResourcesPlugin.getWorkspace().getRoot().getFolder(outputPath)).exists()) {
                    binaryFolders.add(folder2);
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        return binaryFolders;
    }

    public Set<IFolder> getSourceFolders(IProject project) {
        HashSet<IFolder> sourceFolders = new HashSet<IFolder>();
        IJavaProject jp = this.getProject(project);
        if (jp == null) {
            return sourceFolders;
        }
        try {
            IClasspathEntry[] iClasspathEntryArray = jp.getRawClasspath();
            int n = iClasspathEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry entry = iClasspathEntryArray[n2];
                if (entry.getEntryKind() == 3) {
                    IPath srcPath = entry.getPath();
                    IFolder folder = ResourcesPlugin.getWorkspace().getRoot().getFolder(srcPath);
                    if (folder.exists()) {
                        sourceFolders.add(folder);
                    }
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        return sourceFolders;
    }
}

