/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.common.internal.builder;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.IParameter;
import org.eclipse.core.commands.Parameterization;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.osgi.util.NLS;
import org.eclipse.stp.sca.common.internal.Messages;
import org.eclipse.stp.sca.common.utils.ResourceUtils;
import org.eclipse.stp.sca.common.utils.ScaSignature;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScaMarkerHelper {
    public static void createScaMarkers(Diagnostic diagnostic, IFile iFile, String markerType) {
        if (diagnostic.getChildren() == null || diagnostic.getChildren().isEmpty()) {
            if (diagnostic.getSeverity() == 0) {
                return;
            }
            try {
                Object o;
                IMarker marker = iFile.createMarker(markerType);
                marker.setAttribute("lineNumber", 1);
                marker.setAttribute("priority", 1);
                if (diagnostic.getSeverity() < 2) {
                    marker.setAttribute("severity", 0);
                } else if (diagnostic.getSeverity() < 4) {
                    marker.setAttribute("severity", 1);
                } else {
                    marker.setAttribute("severity", 2);
                }
                String message = diagnostic.getMessage();
                message = String.valueOf(message) + (message.endsWith(".") ? "" : ".");
                marker.setAttribute("message", (Object)message);
                List data = diagnostic.getData();
                if (data != null && !data.isEmpty() && (o = diagnostic.getData().get(0)) != null && o instanceof EObject) {
                    ScaSignature sig = new ScaSignature((EObject)o);
                    marker.setAttribute("signature", (Object)sig.toString());
                    String xpathSignature = ScaMarkerHelper.getXpathExpression((EObject)o);
                    marker.setAttribute("xpath-signature", (Object)xpathSignature);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            for (Diagnostic childDiagnostic : diagnostic.getChildren()) {
                int maxSeverity = 0;
                try {
                    Object o;
                    IMarker marker = iFile.createMarker(markerType);
                    marker.setAttribute("lineNumber", 1);
                    marker.setAttribute("priority", 1);
                    if (childDiagnostic.getSeverity() < 2) {
                        marker.setAttribute("severity", 0);
                        if (maxSeverity < 2) {
                            maxSeverity = 1;
                        }
                    } else if (childDiagnostic.getSeverity() < 4) {
                        marker.setAttribute("severity", 1);
                        if (maxSeverity < 4) {
                            maxSeverity = 2;
                        }
                    } else {
                        marker.setAttribute("severity", 2);
                        maxSeverity = 4;
                    }
                    String message = childDiagnostic.getMessage();
                    message = String.valueOf(message) + (message.endsWith(".") ? "" : ".");
                    marker.setAttribute("message", (Object)message);
                    List data = childDiagnostic.getData();
                    if (data == null || data.isEmpty() || (o = data.get(0)) == null || !(o instanceof EObject)) continue;
                    ScaSignature sig = new ScaSignature((EObject)o);
                    marker.setAttribute("signature", (Object)sig.toString());
                    String xpathSignature = ScaMarkerHelper.getXpathExpression((EObject)o);
                    marker.setAttribute("xpath-signature", (Object)xpathSignature);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        ScaMarkerHelper.resolveLineNumbers(iFile, markerType);
    }

    public static void createMarker(IFile file, String markerType, String message, int severity, EObject eObject) {
        try {
            try {
                IMarker marker = file.createMarker(markerType);
                marker.setAttribute("severity", severity);
                marker.setAttribute("priority", 1);
                marker.setAttribute("message", (Object)message);
                if (eObject != null) {
                    ScaSignature sig = new ScaSignature(eObject);
                    marker.setAttribute("signature", (Object)sig.toString());
                    String xpathSignature = ScaMarkerHelper.getXpathExpression(eObject);
                    marker.setAttribute("xpath-signature", (Object)xpathSignature);
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
                ScaMarkerHelper.resolveLineNumbers(file, markerType);
            }
        }
        finally {
            ScaMarkerHelper.resolveLineNumbers(file, markerType);
        }
    }

    public static void createAllScaMarkers(Map<Diagnostic, File> diagnostics) {
        IFile f;
        HashMap<File, IFile> filesMapping = new HashMap<File, IFile>(diagnostics.size() / 3);
        for (File file : diagnostics.values()) {
            if (filesMapping.containsKey(file)) continue;
            f = ResourceUtils.getIFile(file);
            filesMapping.put(file, f);
        }
        for (Map.Entry entry : diagnostics.entrySet()) {
            f = (IFile)filesMapping.get(entry.getValue());
            if (f == null) continue;
            ScaMarkerHelper.createScaMarkers((Diagnostic)entry.getKey(), f, "org.eclipse.stp.sca.common.composite");
        }
        for (Map.Entry entry : diagnostics.entrySet()) {
            f = (IFile)filesMapping.get(entry.getValue());
            if (f == null) continue;
            ScaMarkerHelper.createFakeDiagMarker(f);
        }
    }

    private static void createFakeDiagMarker(IFile compositeFile) {
        IFile diagFile = ScaMarkerHelper.getCompositeDiagramFile(compositeFile);
        if (diagFile == null) {
            return;
        }
        int severity = 4;
        try {
            severity = compositeFile.findMaxProblemSeverity("org.eclipse.stp.sca.common.composite", true, 0);
        }
        catch (CoreException e1) {
            e1.printStackTrace();
        }
        try {
            int formerSeverity = diagFile.findMaxProblemSeverity("org.eclipse.stp.sca.common.fDiagram", true, 0);
            if (formerSeverity < severity) {
                diagFile.deleteMarkers("org.eclipse.stp.sca.common.fDiagram", true, 0);
                String msg = NLS.bind((String)Messages.MarkerHelper_0, (Object)compositeFile.getName());
                ScaMarkerHelper.createMarker(diagFile, "org.eclipse.stp.sca.common.fDiagram", msg, severity, null);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public static IFile getCompositeDiagramFile(IFile compositeFile) {
        if (compositeFile == null || !compositeFile.getName().endsWith(".composite")) {
            return null;
        }
        try {
            IPath compPath = compositeFile.getProjectRelativePath().removeFileExtension().addFileExtension("composite_diagram");
            IFile compositeDiagramFile = compositeFile.getProject().getFile(compPath);
            if (compositeDiagramFile.exists()) {
                return compositeDiagramFile;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void clearScaMarkers(IResource resource, int depth) {
        try {
            resource.deleteMarkers("org.eclipse.stp.sca.common.composite", true, depth);
            resource.deleteMarkers("org.eclipse.stp.sca.common.fDiagram", true, depth);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public static void clearScaMarkers(IFile file) {
        try {
            file.deleteMarkers("org.eclipse.stp.sca.common.composite", true, 1);
            file.deleteMarkers("org.eclipse.stp.sca.common.fDiagram", true, 1);
            IFile f = ScaMarkerHelper.getCompositeDiagramFile(file);
            if (f != null) {
                f.deleteMarkers("org.eclipse.stp.sca.common.fDiagram", true, 1);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private static void resolveLineNumbers(IFile file, String markerType) {
        ICommandService cmdService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Command lineResolverCmd = cmdService.getCommand("org.eclipse.stp.sca.xmleditors.lineResolver");
        try {
            IParameter paramId = lineResolverCmd.getParameter("org.eclipse.stp.sca.xmleditors.lineresolver.file");
            Parameterization fileParam = new Parameterization(paramId, file.getFullPath().toString());
            paramId = lineResolverCmd.getParameter("org.eclipse.stp.sca.xmleditors.lineresolver.marker-id");
            Parameterization markerIdParam = new Parameterization(paramId, markerType);
            paramId = lineResolverCmd.getParameter("org.eclipse.stp.sca.xmleditors.lineresolver.marker-attribute");
            Parameterization markerAttributeParam = new Parameterization(paramId, "xpath-signature");
            ParameterizedCommand parmCommand = new ParameterizedCommand(lineResolverCmd, new Parameterization[]{fileParam, markerIdParam, markerAttributeParam});
            IHandlerService ds = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
            ds.executeCommand(parmCommand, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String getXpathExpression(EObject object) {
        StringBuilder sb = new StringBuilder();
        while (object != null) {
            if (object.eContainmentFeature() != null) {
                String index = "";
                if (object.eContainingFeature().isMany()) {
                    int pos;
                    Object o = object.eContainer().eGet(object.eContainingFeature());
                    if (o instanceof FeatureMap) {
                        pos = -1;
                        for (Object unknownObject : (FeatureMap)o) {
                            ++pos;
                            if (unknownObject instanceof FeatureMap.Entry && object.equals(unknownObject = ((FeatureMap.Entry)unknownObject).getValue())) break;
                        }
                        index = "[" + (pos + 1) + "]";
                    } else if (o instanceof EList) {
                        pos = ((EList)o).indexOf((Object)object) + 1;
                        index = "[" + pos + "]";
                    }
                }
                String name = ExtendedMetaData.INSTANCE.getName((EStructuralFeature)object.eContainmentFeature());
                sb.insert(0, "/*[local-name()='" + name + "']" + index);
            }
            object = object.eContainer();
        }
        return sb.toString();
    }
}

