/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.common.internal.provisional.builder;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.osgi.util.NLS;
import org.eclipse.stp.sca.Composite;
import org.eclipse.stp.sca.Include;
import org.eclipse.stp.sca.common.ScaCommonPlugin;
import org.eclipse.stp.sca.common.internal.Messages;
import org.eclipse.stp.sca.common.internal.provisional.SuperComposite;
import org.eclipse.stp.sca.common.internal.provisional.builder.ScaAbstractValidationExtension;
import org.eclipse.stp.sca.common.utils.ScaModelUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScaValidator {
    private final List<ScaAbstractValidationExtension> extensions = new ArrayList<ScaAbstractValidationExtension>();
    private ScaModelUtils scaModelUtils;

    public boolean addValidationExtension(ScaAbstractValidationExtension o) {
        return this.extensions.add(o);
    }

    public boolean addAllValidationExtensions(Collection<? extends ScaAbstractValidationExtension> c) {
        return this.extensions.addAll(c);
    }

    public Map<Diagnostic, File> performValidation(List<File> filesToValidate, File[] rootContainers) {
        BasicDiagnostic d;
        HashMap<Diagnostic, File> diagnostics = new HashMap<Diagnostic, File>();
        this.scaModelUtils = new ScaModelUtils();
        HashMap<File, Composite> fileToComposite = new HashMap<File, Composite>();
        for (File file : filesToValidate) {
            try {
                Composite composite = this.scaModelUtils.getCompositeFile(file);
                fileToComposite.put(file, composite);
            }
            catch (ScaModelUtils.InvalidScaModelException e) {
                String filename = file.getName();
                String message = NLS.bind((String)Messages.IncrementalBuilder_2, (Object)filename);
                d = new BasicDiagnostic(4, file.getAbsolutePath(), 0, message, new Object[0]);
                diagnostics.put((Diagnostic)d, file);
            }
        }
        if (!diagnostics.isEmpty()) {
            return diagnostics;
        }
        for (Map.Entry entry : fileToComposite.entrySet()) {
            String compositeName;
            String filename = ((File)entry.getKey()).getName();
            if (filename.equals(String.valueOf(compositeName = ((Composite)entry.getValue()).getName()) + ".composite")) continue;
            String message2 = NLS.bind((String)Messages.IncrementalBuilder_3, (Object)filename);
            d = new BasicDiagnostic(4, ((File)entry.getKey()).getAbsolutePath(), 0, message2, new Object[]{entry.getValue()});
            diagnostics.put((Diagnostic)d, (File)entry.getKey());
        }
        if (!diagnostics.isEmpty()) {
            return diagnostics;
        }
        FileFilter fileFilter = new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.getName().toLowerCase().endsWith(".composite");
            }
        };
        HashMap<String, ArrayList<File>> compositeFilesByName = new HashMap<String, ArrayList<File>>();
        d = rootContainers;
        int message2 = ((BasicDiagnostic)d).length;
        int compositeName = 0;
        while (compositeName < message2) {
            BasicDiagnostic container = d[compositeName];
            File[] compositeFiles = container.listFiles(fileFilter);
            if (compositeFiles != null) {
                File[] fileArray = compositeFiles;
                int n = compositeFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    File compositeFile = fileArray[n2];
                    ArrayList<File> f = (ArrayList<File>)compositeFilesByName.get(compositeFile.getName());
                    if (f == null) {
                        f = new ArrayList<File>();
                    }
                    f.add(compositeFile);
                    compositeFilesByName.put(compositeFile.getName(), f);
                    ++n2;
                }
            }
            ++compositeName;
        }
        for (List f : compositeFilesByName.values()) {
            if (f == null || f.size() == 1) continue;
            HashMap<QName, File> compositeIds = new HashMap<QName, File>();
            for (File compositeFile : f) {
                Composite composite = (Composite)fileToComposite.get(compositeFile);
                if (composite == null) {
                    try {
                        composite = this.scaModelUtils.getCompositeFile(compositeFile);
                    }
                    catch (ScaModelUtils.InvalidScaModelException e) {
                        continue;
                    }
                }
                String name = composite.getName();
                String tns = composite.getTargetNamespace();
                QName id = new QName(tns, name);
                File conflictFile = (File)compositeIds.get(id);
                if (conflictFile == null) {
                    compositeIds.put(id, compositeFile);
                    continue;
                }
                String message3 = NLS.bind((String)Messages.IncrementalBuilder_5, (Object[])new Object[]{name, tns});
                if (filesToValidate.contains(conflictFile)) {
                    BasicDiagnostic d2 = new BasicDiagnostic(4, conflictFile.getAbsolutePath(), 0, message3, new Object[]{fileToComposite.get(conflictFile)});
                    diagnostics.put((Diagnostic)d2, conflictFile);
                }
                if (!filesToValidate.contains(compositeFile)) continue;
                BasicDiagnostic d2 = new BasicDiagnostic(4, compositeFile.getAbsolutePath(), 0, message3, new Object[]{fileToComposite.get(compositeFile)});
                diagnostics.put((Diagnostic)d2, compositeFile);
            }
        }
        if (!diagnostics.isEmpty()) {
            return diagnostics;
        }
        HashMap<File, SuperComposite> fileToSuperComposite = new HashMap<File, SuperComposite>();
        for (Map.Entry entry : fileToComposite.entrySet()) {
            SuperComposite sc = new SuperComposite((Composite)entry.getValue(), (File[])rootContainers, this.scaModelUtils);
            fileToSuperComposite.put((File)entry.getKey(), sc);
        }
        fileToComposite = null;
        for (Map.Entry entry : fileToSuperComposite.entrySet()) {
            for (Include include : ((SuperComposite)((Object)entry.getValue())).getUnresolvedInclusions()) {
                String msg = "The included composite " + include.getName().getLocalPart() + " could  not be resolved.";
                BasicDiagnostic d3 = new BasicDiagnostic(4, ((File)entry.getKey()).getAbsolutePath(), 0, msg, new Object[]{entry.getValue()});
                diagnostics.put((Diagnostic)d3, (File)entry.getKey());
            }
        }
        if (!diagnostics.isEmpty()) {
            return diagnostics;
        }
        diagnostics.putAll(this.getDependencyLoops(fileToSuperComposite));
        if (!diagnostics.isEmpty()) {
            return diagnostics;
        }
        for (Map.Entry entry : fileToSuperComposite.entrySet()) {
            Diagnostic diagnostic = ScaModelUtils.validate((Composite)entry.getValue());
            if (diagnostic.getSeverity() != 0) {
                diagnostics.put(diagnostic, (File)entry.getKey());
            }
            for (ScaAbstractValidationExtension ext : this.extensions) {
                if (!ext.initialize((Composite)entry.getValue(), (File)entry.getKey())) continue;
                try {
                    diagnostics.putAll(ext.validatePreRequisites());
                    diagnostics.putAll(ext.validateInterfaceCompatibilityInPromotes());
                    diagnostics.putAll(ext.validateInterfaceCompatibilityInWires());
                    diagnostics.putAll(ext.validateInterfaceImplementations());
                    diagnostics.putAll(ext.validateReferencesInImplementations());
                    diagnostics.putAll(ext.validateOthers());
                }
                catch (Exception e) {
                    ScaCommonPlugin.log(e, 4);
                }
            }
        }
        return diagnostics;
    }

    private Map<Diagnostic, File> getDependencyLoops(Map<File, SuperComposite> fileToSuperComposite) {
        HashMap<Diagnostic, File> diagnostics = new HashMap<Diagnostic, File>();
        for (Map.Entry<File, SuperComposite> entry : fileToSuperComposite.entrySet()) {
            try {
                this.getAtomicDependencies(entry.getValue(), null);
            }
            catch (DependenciesCycleException e) {
                String rel = String.valueOf(e.loopStart.getName()) + " -> " + e.loopEnd.getName();
                String message = NLS.bind((String)Messages.IncrementalBuilder_8, (Object)rel);
                BasicDiagnostic d = new BasicDiagnostic(4, entry.getKey().getAbsolutePath(), 0, message, new Object[]{entry.getValue()});
                diagnostics.put((Diagnostic)d, entry.getKey());
            }
        }
        return diagnostics;
    }

    private List<Composite> getAtomicDependencies(SuperComposite sc, List<Composite> forbiddenInclusions) throws DependenciesCycleException {
        if (forbiddenInclusions == null) {
            forbiddenInclusions = new ArrayList<Composite>();
            forbiddenInclusions.add((Composite)sc);
        }
        ArrayList<Composite> result = new ArrayList<Composite>();
        for (SuperComposite inclusion : sc.getResolvedInclusions()) {
            Composite composite = inclusion.getMainComposite();
            if (forbiddenInclusions.contains(composite)) {
                throw new DependenciesCycleException(composite, sc.getMainComposite());
            }
            result.add(composite);
            forbiddenInclusions.add(composite);
            List<Composite> subResult = this.getAtomicDependencies(inclusion, forbiddenInclusions);
            result.addAll(subResult);
        }
        return result;
    }

    private class DependenciesCycleException
    extends Exception {
        private static final long serialVersionUID = 7178811675332575864L;
        private final Composite loopStart;
        private final Composite loopEnd;

        DependenciesCycleException(Composite loopStart, Composite loopEnd) {
            this.loopEnd = loopEnd;
            this.loopStart = loopStart;
        }
    }
}

