/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.common.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.stp.sca.common.ScaCommonPlugin;
import org.eclipse.stp.sca.common.internal.provisional.filters.ScaResourceFiltersEPManager;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceUtils {
    public static List<IFile> getFiles(String extension, Collection<? extends IContainer> containers) {
        ArrayList<IFile> result = new ArrayList<IFile>();
        if (containers == null) {
            return result;
        }
        for (IContainer iContainer : containers) {
            try {
                IResource[] resources;
                IResource[] iResourceArray = resources = iContainer.members();
                int n = resources.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource resource = iResourceArray[n2];
                    switch (resource.getType()) {
                        case 1: {
                            String fileExtension = resource.getFileExtension();
                            if (fileExtension == null || !(fileExtension = resource.getFileExtension().toLowerCase()).equals(extension) && !fileExtension.equals("*")) break;
                            result.add((IFile)resource);
                            break;
                        }
                        case 2: {
                            IFolder subFolder = (IFolder)resource;
                            result.addAll(ResourceUtils.getFiles(extension, Arrays.asList(subFolder)));
                            break;
                        }
                    }
                    ++n2;
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static List<IFolder> getFolders(IContainer container) {
        ArrayList<IFolder> result = new ArrayList<IFolder>();
        try {
            IResource[] resources;
            IResource[] iResourceArray = resources = container.members();
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                switch (resource.getType()) {
                    case 2: {
                        IFolder subFolder = (IFolder)resource;
                        result.add(subFolder);
                        result.addAll(ResourceUtils.getFolders((IContainer)subFolder));
                    }
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static IFile getIFileFromEditor() {
        try {
            IEditorPart editorPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
            return ((FileEditorInput)editorPart.getEditorInput()).getFile();
        }
        catch (Exception e) {
            Status status = new Status(4, "org.eclipse.stp.sca.common", "Error while trying to get the file from the active editor.", (Throwable)e);
            ScaCommonPlugin.getDefault().getLog().log((IStatus)status);
            return null;
        }
    }

    public static IResource[] getDirectValidChildren(IContainer container, List<String> extensions, List<IResource> resourcesToSkip) {
        IResource[] res;
        if (container instanceof IProject && !((IProject)container).isOpen()) {
            return new IResource[0];
        }
        try {
            res = container.members();
        }
        catch (CoreException e) {
            e.printStackTrace();
            res = new IResource[]{};
        }
        ArrayList<IResource> resources = new ArrayList<IResource>();
        IResource[] iResourceArray = res;
        int n = res.length;
        int n2 = 0;
        while (n2 < n) {
            IResource r = iResourceArray[n2];
            if (!resourcesToSkip.contains(r)) {
                String extension;
                if (r instanceof IContainer) {
                    IResource[] subRes = ResourceUtils.getDirectValidChildren((IContainer)r, extensions, resourcesToSkip);
                    if (subRes.length > 0) {
                        resources.add(r);
                    }
                } else if (r instanceof IFile && extensions.contains(extension = ((IFile)r).getFileExtension())) {
                    resources.add(r);
                }
            }
            ++n2;
        }
        res = new IResource[resources.size()];
        return resources.toArray(res);
    }

    public static IResource[] getDirectValidChildren(IContainer container, String[] extensions, List<IResource> resourcesToSkip) {
        return ResourceUtils.getDirectValidChildren(container, Arrays.asList(extensions), resourcesToSkip);
    }

    public static File getPluginBinaryPath(String pluginId, String binaryFolderName) {
        if (binaryFolderName == null || binaryFolderName.trim().length() == 0) {
            binaryFolderName = "bin";
        }
        try {
            File binaryFolder;
            File bundleFile = FileLocator.getBundleFile((Bundle)Platform.getBundle((String)pluginId));
            if (bundleFile.isFile()) {
                return bundleFile;
            }
            if (bundleFile.isDirectory() && (binaryFolder = new File(bundleFile, binaryFolderName)).exists() && binaryFolder.isDirectory()) {
                return binaryFolder;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static IFile getIFile(File file) {
        Path path = new Path(file.getAbsolutePath());
        return ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)path);
    }

    public static IFile getCompositeFile(String compositeName) {
        if (compositeName == null) {
            return null;
        }
        IFile result = null;
        IFile currentCompositeFile = ResourceUtils.getIFileFromEditor();
        if (currentCompositeFile == null) {
            return null;
        }
        IProject project = currentCompositeFile.getProject();
        Set<IFolder> sourceFolders = ScaResourceFiltersEPManager.getInstance().getSourceFolders(project);
        List<IFile> composites = ResourceUtils.getFiles("composite", sourceFolders);
        for (IFile compositeFile : composites) {
            if (!compositeName.equals(compositeFile.getName())) continue;
            result = compositeFile;
        }
        if (result == null) {
            try {
                IProject[] projects = project.getReferencedProjects();
                if (projects == null) {
                    projects = new IProject[]{};
                }
                IProject[] iProjectArray = projects;
                int n = projects.length;
                int n2 = 0;
                while (n2 < n) {
                    IProject refProject = iProjectArray[n2];
                    sourceFolders = ScaResourceFiltersEPManager.getInstance().getSourceFolders(refProject);
                    composites = ResourceUtils.getFiles("composite", sourceFolders);
                    for (IFile compositeFile : composites) {
                        if (!compositeName.equals(compositeFile.getName())) continue;
                        result = compositeFile;
                    }
                    ++n2;
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return result;
    }

    public static IResource getResource(File file) {
        Path path = new Path(file.getAbsolutePath());
        if (file.isFile()) {
            return ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)path);
        }
        return ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation((IPath)path);
    }

    public static List<File> getIoFiles(String extension, File ... containers) {
        ArrayList<File> files = new ArrayList<File>();
        if (containers == null) {
            return files;
        }
        extension = extension.toLowerCase();
        File[] fileArray = containers;
        int n = containers.length;
        int n2 = 0;
        while (n2 < n) {
            File container = fileArray[n2];
            String[] paths = container.list();
            if (paths != null) {
                String[] stringArray = paths;
                int n3 = paths.length;
                int n4 = 0;
                while (n4 < n3) {
                    String path = stringArray[n4];
                    File file = new File(container, path);
                    if (file.isFile()) {
                        if ("*".equals(extension) || file.getName().toLowerCase().endsWith("." + extension)) {
                            files.add(file);
                        }
                    } else if (file.isDirectory()) {
                        files.addAll(ResourceUtils.getIoFiles(extension, file));
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return files;
    }
}

