/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.csa.diagram.extension.edit.part;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.stp.sca.csa.diagram.extension.edit.part.BindingInformation;
import org.eclipse.stp.sca.csa.diagram.extension.edit.part.ElementInformation;
import org.eclipse.stp.sca.csa.diagram.extension.edit.part.ElementInformationFactory;
import org.eclipse.stp.sca.csa.diagram.extension.edit.part.ElementType;
import org.eclipse.stp.sca.csa.diagram.extension.edit.part.ImplementationInformation;
import org.eclipse.stp.sca.csa.diagram.extension.edit.part.InterfaceInformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementInformationRegistry {
    public static final String BINDING_EXTENSION_POINT_ID = "org.eclipse.stp.sca.csa.diagram.extension.bindings";
    public static final String INTERFACE_EXTENSION_POINT_ID = "org.eclipse.stp.sca.csa.diagram.extension.interfaces";
    public static final String IMPLEMENTATION_EXTENSION_POINT_ID = "org.eclipse.stp.sca.csa.diagram.extension.implementations";
    private static ElementInformationRegistry elementInformationRegistry;
    private Map<String, BindingInformation> bindingInformations = new HashMap<String, BindingInformation>();
    private Map<String, InterfaceInformation> interfaceInformations;
    private Map<String, ImplementationInformation> implementationInformations = new HashMap<String, ImplementationInformation>();

    public static ElementInformationRegistry getInstance() {
        if (elementInformationRegistry == null) {
            elementInformationRegistry = new ElementInformationRegistry();
            elementInformationRegistry.init();
        }
        return elementInformationRegistry;
    }

    void init() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        elementInformationRegistry.init(registry.getExtensionPoint(BINDING_EXTENSION_POINT_ID), this.bindingInformations, BindingInformation.class, ElementType.BINDING);
        elementInformationRegistry.init(registry.getExtensionPoint(INTERFACE_EXTENSION_POINT_ID), this.interfaceInformations, InterfaceInformation.class, ElementType.INTERFACE);
        elementInformationRegistry.init(registry.getExtensionPoint(IMPLEMENTATION_EXTENSION_POINT_ID), this.implementationInformations, ImplementationInformation.class, ElementType.IMPLEMENTATION);
    }

    void init(IExtensionPoint point, Map elementInformations, Class clazz, ElementType type) {
        if (point != null) {
            IExtension[] extensions;
            IExtension[] iExtensionArray = extensions = point.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    ElementInformation elementInformation = null;
                    if ("element".equals(element.getName())) {
                        elementInformation = this.init2(element, type);
                    } else if ("elementInformation".equals(element.getName())) {
                        elementInformation = this.init3(element, clazz);
                    }
                    if (elementInformation != null) {
                        elementInformations.put(elementInformation.getElementType().getId(), elementInformation);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
    }

    private ElementInformation init2(IConfigurationElement element, ElementType type) {
        ElementInformation elementInformation = null;
        String typeId = element.getAttribute("typeId");
        String literalField = element.getAttribute("literalField");
        String literalClass = element.getAttribute("literalClass");
        String contributorName = element.getDeclaringExtension().getContributor().getName();
        EStructuralFeature elementLiteral = null;
        try {
            Class javaClass = Platform.getBundle((String)contributorName).loadClass(literalClass);
            Field field = javaClass.getField(literalField);
            elementLiteral = (EStructuralFeature)EStructuralFeature.class.cast(field.get(null));
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (NoSuchFieldException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
        String iconPath = element.getAttribute("iconPath");
        ElementInformationFactory factory = new ElementInformationFactory();
        try {
            factory.setTypeId(typeId);
            factory.setElementLiteral(elementLiteral);
            factory.setIconPath(iconPath);
            elementInformation = factory.createElementInformation(type);
        }
        catch (Exception e) {
            return null;
        }
        return elementInformation;
    }

    private ElementInformation init3(IConfigurationElement element, Class<? extends ElementInformation> clazz) {
        ElementInformation elementInformation = null;
        String className = element.getAttribute("class");
        String contributorName = element.getDeclaringExtension().getContributor().getName();
        try {
            Class javaClass = Platform.getBundle((String)contributorName).loadClass(className);
            Object obj = javaClass.newInstance();
            if (clazz.isInstance(obj)) {
                elementInformation = clazz.cast(obj);
            }
        }
        catch (Exception e) {
            return null;
        }
        return elementInformation;
    }

    private ElementInformationRegistry() {
        this.interfaceInformations = new HashMap<String, InterfaceInformation>();
    }

    public ElementInformation getElementInformation(ElementType type, String elementTypeId) {
        ElementInformation result = null;
        switch (type) {
            case BINDING: {
                result = this.bindingInformations.get(elementTypeId);
                break;
            }
            case IMPLEMENTATION: {
                result = this.implementationInformations.get(elementTypeId);
                break;
            }
            case INTERFACE: {
                result = this.interfaceInformations.get(elementTypeId);
            }
        }
        return result;
    }

    public Collection<ElementInformation> getAllElementInformations(ElementType type) {
        ArrayList<ElementInformation> result = null;
        switch (type) {
            case BINDING: {
                result = new ArrayList<ElementInformation>();
                for (Map.Entry<String, BindingInformation> entry : this.bindingInformations.entrySet()) {
                    result.add(entry.getValue());
                }
                break;
            }
            case IMPLEMENTATION: {
                result = new ArrayList();
                for (Map.Entry<String, ImplementationInformation> entry : this.implementationInformations.entrySet()) {
                    result.add(entry.getValue());
                }
                break;
            }
            case INTERFACE: {
                result = new ArrayList();
                for (Map.Entry<String, InterfaceInformation> entry : this.interfaceInformations.entrySet()) {
                    result.add(entry.getValue());
                }
                break;
            }
        }
        return result;
    }
}

