/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.csa.diagram.extension.edit.part;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.diagram.core.providers.AbstractViewProvider;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.stp.sca.csa.diagram.extension.edit.part.ElementInformation;
import org.eclipse.stp.sca.csa.diagram.extension.edit.part.ElementInformationRegistry;
import org.eclipse.stp.sca.csa.diagram.extension.edit.part.ElementType;
import org.eclipse.stp.sca.csa.diagram.extension.edit.part.Utils;
import org.eclipse.stp.sca.csa.diagram.part.CsaVisualIDRegistry;

public abstract class ElementViewProvider
extends AbstractViewProvider {
    private ElementType type = null;

    protected ElementViewProvider(ElementType type) {
        this.type = type;
    }

    protected boolean canCreateNode(View containerView, int nodeVisualID) {
        for (ElementInformation elementInformation : ElementInformationRegistry.getInstance().getAllElementInformations(this.type)) {
            if (!elementInformation.getVisualIDRegistry().canCreateNode(containerView, nodeVisualID)) continue;
            return true;
        }
        return false;
    }

    protected int getNodeVisualID(View containerView, EObject domainElement) {
        for (ElementInformation elementInformation : ElementInformationRegistry.getInstance().getAllElementInformations(this.type)) {
            int result = elementInformation.getVisualIDRegistry().getNodeVisualID(containerView, domainElement);
            if (result < 0) continue;
            return result;
        }
        return -1;
    }

    protected boolean isKnownElementType(IElementType elementType) {
        for (ElementInformation elementInformation : ElementInformationRegistry.getInstance().getAllElementInformations(this.type)) {
            if (!elementInformation.isKnownElementType(elementType)) continue;
            return true;
        }
        return false;
    }

    protected Class getNodeViewClass(IAdaptable semanticAdapter, View containerView, String semanticHint) {
        int visualID;
        if (containerView == null) {
            return null;
        }
        IElementType elementType = this.getSemanticElementType(semanticAdapter);
        EObject domainElement = this.getSemanticElement(semanticAdapter);
        if (semanticHint == null) {
            if (elementType != null || domainElement == null) {
                return null;
            }
            visualID = this.getNodeVisualID(containerView, domainElement);
        } else {
            visualID = Utils.getVisualID(semanticHint);
            if (elementType != null) {
                if (!this.isKnownElementType(elementType) || !(elementType instanceof IHintedType)) {
                    return null;
                }
                String elementTypeHint = ((IHintedType)elementType).getSemanticHint();
                if (!semanticHint.equals(elementTypeHint)) {
                    return null;
                }
                if (domainElement != null && visualID != this.getNodeVisualID(containerView, domainElement)) {
                    return null;
                }
            } else {
                if (!"Csa".equals(this.getModelID(containerView))) {
                    return null;
                }
                boolean matchId = false;
                for (ElementInformation elementInformation : ElementInformationRegistry.getInstance().getAllElementInformations(this.type)) {
                    if (visualID != elementInformation.getVisualID()) continue;
                    matchId = true;
                    if (domainElement != null && visualID == elementInformation.getVisualIDRegistry().getNodeVisualID(containerView, domainElement)) continue;
                    return null;
                }
                if (!matchId) {
                    return null;
                }
            }
        }
        return this.getNodeViewClass(containerView, visualID);
    }

    protected Class getNodeViewClass(View containerView, int visualID) {
        if (containerView == null || !this.canCreateNode(containerView, visualID)) {
            return null;
        }
        for (ElementInformation elementInformation : ElementInformationRegistry.getInstance().getAllElementInformations(this.type)) {
            if (visualID != elementInformation.getVisualID()) continue;
            return elementInformation.getViewFactoryClass();
        }
        return null;
    }

    private IElementType getSemanticElementType(IAdaptable semanticAdapter) {
        if (semanticAdapter == null) {
            return null;
        }
        return (IElementType)semanticAdapter.getAdapter(IElementType.class);
    }

    protected String getModelID(View view) {
        return CsaVisualIDRegistry.getModelID((View)view);
    }

    protected int getVisualID(String type) {
        return CsaVisualIDRegistry.getVisualID((String)type);
    }
}

