/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.csa.diagram.customactions;

import java.util.Collection;
import org.eclipse.draw2d.ScrollPane;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramCommandStack;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.stp.sca.csa.diagram.edit.parts.ComponentComponentPropertyCompartmentEditPart;
import org.eclipse.stp.sca.csa.diagram.edit.parts.ComponentComponentReferenceCompartmentEditPart;
import org.eclipse.stp.sca.csa.diagram.edit.parts.ComponentComponentServiceCompartmentEditPart;
import org.eclipse.stp.sca.csa.diagram.edit.parts.ComponentEditPart;
import org.eclipse.stp.sca.csa.diagram.edit.parts.CompositeCompositeAreaCompartmentEditPart;
import org.eclipse.stp.sca.csa.diagram.edit.parts.CompositeEditPart;
import org.eclipse.stp.sca.csa.diagram.edit.parts.DocumentRootEditPart;
import org.eclipse.ui.IActionDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoSizeAction
extends Action
implements IActionDelegate {
    private GraphicalEditPart myPart;
    private static final int BASE_SHIFT_HEIGHT = 125;
    private static final int SHIFT_BETWEEN_SERVICES = 40;
    private static final int BASE_SHIFT_WIDTH = 180;
    private static final int SHIFT_BETWEEN_PROPERTIES = 40;
    private static final int BASE_COMPOSITE_PADDING = 40;

    public AutoSizeAction() {
    }

    public AutoSizeAction(GraphicalEditPart part) {
        this.myPart = part;
    }

    public void run() {
        if (this.myPart != null) {
            if (this.myPart instanceof CompositeEditPart) {
                this.resize((CompositeEditPart)this.myPart);
            } else if (this.myPart instanceof ComponentEditPart) {
                this.resize((ComponentEditPart)this.myPart);
            } else if (this.myPart instanceof CompositeCompositeAreaCompartmentEditPart) {
                this.resize((CompositeEditPart)this.myPart.getParent());
            } else if (this.myPart instanceof DocumentRootEditPart && this.myPart.getChildren() != null && this.myPart.getChildren().get(0) != null && this.myPart.getChildren().get(0) instanceof CompositeEditPart) {
                this.resize((CompositeEditPart)((Object)this.myPart.getChildren().get(0)));
            }
        }
    }

    private Collection<?> resize(CompositeEditPart compositeEditPart) {
        int maxBottomLeftY = 0;
        int maxTopRightX = 0;
        Dimension deltaDim = new Dimension(0, 0);
        for (Object o : compositeEditPart.getChildren()) {
            if (!(o instanceof CompositeCompositeAreaCompartmentEditPart)) continue;
            for (Object oo : ((CompositeCompositeAreaCompartmentEditPart)((Object)o)).getChildren()) {
                if (!(oo instanceof ComponentEditPart)) continue;
                ComponentEditPart tmp = (ComponentEditPart)((Object)oo);
                Point t = this.resize(tmp);
                maxBottomLeftY = Math.max(maxBottomLeftY, t.y);
                maxTopRightX = Math.max(maxTopRightX, t.x);
            }
            CompositeCompositeAreaCompartmentEditPart compositeCompositeAreaCompartmentEditPart = (CompositeCompositeAreaCompartmentEditPart)((Object)o);
            deltaDim = this.computeDelta(compositeCompositeAreaCompartmentEditPart, maxBottomLeftY, maxTopRightX);
        }
        ChangeBoundsRequest resizeRequest = new ChangeBoundsRequest((Object)"resize");
        resizeRequest.setEditParts((EditPart)compositeEditPart);
        resizeRequest.setSizeDelta(deltaDim);
        CompoundCommand cmd = new CompoundCommand("Resize");
        cmd.add(compositeEditPart.getCommand((Request)resizeRequest));
        compositeEditPart.getDiagramEditDomain().getDiagramCommandStack().execute((Command)cmd);
        return DiagramCommandStack.getReturnValues((Command)cmd);
    }

    private Point resize(ComponentEditPart componentEditPart) {
        Point topLeft = componentEditPart.getFigure().getBounds().getTopLeft();
        int deltaWidth = this.computeDeltaWidth(componentEditPart, componentEditPart.getSize().width);
        int deltaHeight = this.computeDeltaHeight(componentEditPart, componentEditPart.getSize().height);
        ChangeBoundsRequest resizeRequest = new ChangeBoundsRequest((Object)"resize");
        resizeRequest.setEditParts((EditPart)componentEditPart);
        resizeRequest.setSizeDelta(new Dimension(deltaWidth, deltaHeight));
        CompoundCommand cmd = new CompoundCommand("Resize");
        cmd.add(componentEditPart.getCommand((Request)resizeRequest));
        componentEditPart.getDiagramEditDomain().getDiagramCommandStack().execute((Command)cmd);
        return new Point(topLeft.x + componentEditPart.getSize().width + deltaWidth, topLeft.y + componentEditPart.getSize().height + deltaHeight);
    }

    private int computeDeltaWidth(ComponentEditPart componentEditPart, int oldWidth) {
        int properties = 0;
        for (Object o : componentEditPart.getChildren()) {
            if (!(o instanceof ComponentComponentPropertyCompartmentEditPart)) continue;
            properties = ((ComponentComponentPropertyCompartmentEditPart)((Object)o)).getChildren().size();
        }
        if (--properties < 0) {
            properties = 0;
        }
        return -oldWidth + properties * 40 + 180;
    }

    private int computeDeltaHeight(ComponentEditPart componentEditPart, int oldHeight) {
        int service = 0;
        int reference = 0;
        for (Object o : componentEditPart.getChildren()) {
            if (o instanceof ComponentComponentServiceCompartmentEditPart) {
                service = ((ComponentComponentServiceCompartmentEditPart)((Object)o)).getChildren().size();
                continue;
            }
            if (!(o instanceof ComponentComponentReferenceCompartmentEditPart)) continue;
            reference = ((ComponentComponentReferenceCompartmentEditPart)((Object)o)).getChildren().size();
        }
        int max = Math.max(service, reference);
        if (max >= 1) {
            --max;
        }
        return -oldHeight + max * 40 + 125;
    }

    private Dimension computeDelta(CompositeCompositeAreaCompartmentEditPart compositeCompositeAreaCompartmentEditPart, int height, int width) {
        Dimension deltaDim = new Dimension(0, 0);
        ScrollPane scrollPane = compositeCompositeAreaCompartmentEditPart.getCompartmentFigure().getScrollPane();
        int oldWidth = scrollPane.getHorizontalScrollBar().getExtent();
        int oldHeight = scrollPane.getVerticalScrollBar().getExtent();
        deltaDim.width = -oldWidth + width + 40;
        deltaDim.height = -oldHeight + height + 40;
        return deltaDim;
    }

    public void run(IAction action) {
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        IStructuredSelection iss;
        if (selection instanceof IStructuredSelection && (iss = (IStructuredSelection)selection).getFirstElement() instanceof GraphicalEditPart) {
            this.myPart = (GraphicalEditPart)iss.getFirstElement();
        }
    }
}

