/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.csa.diagram.edit.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientReferenceRelationshipRequest;
import org.eclipse.stp.sca.csa.ComponentReference;
import org.eclipse.stp.sca.csa.ComponentService;
import org.eclipse.stp.sca.csa.diagram.edit.policies.CsaBaseItemSemanticEditPolicy;

public class ComponentReferenceTarget2ReorientCommand
extends EditElementCommand {
    private final int reorientDirection;
    private final EObject referenceOwner;
    private final EObject oldEnd;
    private final EObject newEnd;

    public ComponentReferenceTarget2ReorientCommand(ReorientReferenceRelationshipRequest request) {
        super(request.getLabel(), null, (IEditCommandRequest)request);
        this.reorientDirection = request.getDirection();
        this.referenceOwner = request.getReferenceOwner();
        this.oldEnd = request.getOldRelationshipEnd();
        this.newEnd = request.getNewRelationshipEnd();
    }

    public boolean canExecute() {
        if (!(this.referenceOwner instanceof ComponentReference)) {
            return false;
        }
        if (this.reorientDirection == 1) {
            return this.canReorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.canReorientTarget();
        }
        return false;
    }

    protected boolean canReorientSource() {
        if (!(this.oldEnd instanceof ComponentService) || !(this.newEnd instanceof ComponentReference)) {
            return false;
        }
        return CsaBaseItemSemanticEditPolicy.LinkConstraints.canExistComponentReferenceTarget2_4004(this.getNewSource(), this.getOldTarget());
    }

    protected boolean canReorientTarget() {
        if (!(this.oldEnd instanceof ComponentService) || !(this.newEnd instanceof ComponentService)) {
            return false;
        }
        return CsaBaseItemSemanticEditPolicy.LinkConstraints.canExistComponentReferenceTarget2_4004(this.getOldSource(), this.getNewTarget());
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.canExecute()) {
            throw new ExecutionException("Invalid arguments in reorient link command");
        }
        if (this.reorientDirection == 1) {
            return this.reorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.reorientTarget();
        }
        throw new IllegalStateException();
    }

    protected CommandResult reorientSource() throws ExecutionException {
        this.getOldSource().getTarget().remove((Object)this.getOldTarget());
        this.getNewSource().getTarget().add((Object)this.getOldTarget());
        return CommandResult.newOKCommandResult((Object)this.referenceOwner);
    }

    protected CommandResult reorientTarget() throws ExecutionException {
        this.getOldSource().getTarget().remove((Object)this.getOldTarget());
        this.getOldSource().getTarget().add((Object)this.getNewTarget());
        return CommandResult.newOKCommandResult((Object)this.referenceOwner);
    }

    protected ComponentReference getOldSource() {
        return (ComponentReference)this.referenceOwner;
    }

    protected ComponentReference getNewSource() {
        return (ComponentReference)this.newEnd;
    }

    protected ComponentService getOldTarget() {
        return (ComponentService)this.oldEnd;
    }

    protected ComponentService getNewTarget() {
        return (ComponentService)this.newEnd;
    }
}

