/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.csa.diagram.part;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.stp.sca.csa.diagram.part.CsaCreationWizardPage;
import org.eclipse.stp.sca.csa.diagram.part.CsaDiagramEditorPlugin;
import org.eclipse.stp.sca.csa.diagram.part.CsaDiagramEditorUtil;
import org.eclipse.stp.sca.csa.diagram.part.Messages;
import org.eclipse.stp.sca.csa.util.CsaResourceImpl;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

public class CsaCreationWizard
extends Wizard
implements INewWizard {
    private IWorkbench workbench;
    protected IStructuredSelection selection;
    protected CsaCreationWizardPage diagramModelFilePage;
    protected CsaCreationWizardPage domainModelFilePage;
    protected Resource diagram;
    private boolean openNewlyCreatedDiagramEditor = true;
    private IConfigurationElement configurationElement;

    public IWorkbench getWorkbench() {
        return this.workbench;
    }

    public IStructuredSelection getSelection() {
        return this.selection;
    }

    public final Resource getDiagram() {
        return this.diagram;
    }

    public final boolean isOpenNewlyCreatedDiagramEditor() {
        return this.openNewlyCreatedDiagramEditor;
    }

    public void setOpenNewlyCreatedDiagramEditor(boolean openNewlyCreatedDiagramEditor) {
        this.openNewlyCreatedDiagramEditor = openNewlyCreatedDiagramEditor;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
        this.setWindowTitle(Messages.CsaCreationWizardTitle);
        this.setDefaultPageImageDescriptor(CsaDiagramEditorPlugin.getBundledImageDescriptor("icons/wizban/NewCsaWizard.gif"));
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.diagramModelFilePage = new CsaCreationWizardPage("DiagramModelFile", this.getSelection(), "composite_diagram");
        this.diagramModelFilePage.setTitle(Messages.CsaCreationWizard_DiagramModelFilePageTitle);
        this.diagramModelFilePage.setDescription(Messages.CsaCreationWizard_DiagramModelFilePageDescription);
        this.addPage((IWizardPage)this.diagramModelFilePage);
    }

    private Resource getDomainModelFilePage() {
        URI uri = URI.createURI((String)this.diagramModelFilePage.getURI().toString().replaceAll("composite_diagram", "composite"));
        CsaResourceImpl domainModelFilePage = new CsaResourceImpl(uri);
        return domainModelFilePage;
    }

    public boolean performFinish() {
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(null){

            protected void execute(IProgressMonitor monitor) throws CoreException, InterruptedException {
                CsaCreationWizard.this.diagram = CsaDiagramEditorUtil.createDiagram(CsaCreationWizard.this.diagramModelFilePage.getURI(), CsaCreationWizard.this.getDomainModelFilePage().getURI(), monitor);
                if (CsaCreationWizard.this.isOpenNewlyCreatedDiagramEditor() && CsaCreationWizard.this.diagram != null) {
                    try {
                        CsaDiagramEditorUtil.openDiagram(CsaCreationWizard.this.diagram);
                    }
                    catch (PartInitException e) {
                        ErrorDialog.openError((Shell)CsaCreationWizard.this.getContainer().getShell(), (String)Messages.CsaCreationWizardOpenEditorError, null, (IStatus)e.getStatus());
                    }
                }
            }
        };
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof CoreException) {
                ErrorDialog.openError((Shell)this.getContainer().getShell(), (String)Messages.CsaCreationWizardCreationError, null, (IStatus)((CoreException)e.getTargetException()).getStatus());
            } else {
                CsaDiagramEditorPlugin.getInstance().logError("Error creating diagram", e.getTargetException());
            }
            return false;
        }
        BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.configurationElement);
        return this.diagram != null;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.configurationElement = config;
    }
}

