/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.csa.diagram.part;

import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.stp.sca.csa.CsaPackage;
import org.eclipse.stp.sca.csa.DocumentRoot;
import org.eclipse.stp.sca.csa.diagram.part.CsaDiagramEditorPlugin;

public class CsaVisualIDRegistry {
    private static final String DEBUG_KEY = "org.eclipse.stp.sca.csa.diagram/debug/visualID";

    public static int getVisualID(View view) {
        if (view instanceof Diagram) {
            if ("Csa".equals(view.getType())) {
                return 1000;
            }
            return -1;
        }
        return CsaVisualIDRegistry.getVisualID(view.getType());
    }

    public static String getModelID(View view) {
        Diagram diagram = view.getDiagram();
        while (view != diagram) {
            EAnnotation annotation = view.getEAnnotation("Shortcut");
            if (annotation != null) {
                return (String)annotation.getDetails().get((Object)"modelID");
            }
            view = (View)view.eContainer();
        }
        return diagram != null ? diagram.getType() : null;
    }

    public static int getVisualID(String type) {
        try {
            return Integer.parseInt(type);
        }
        catch (NumberFormatException e) {
            if (Boolean.TRUE.toString().equalsIgnoreCase(Platform.getDebugOption((String)DEBUG_KEY))) {
                CsaDiagramEditorPlugin.getInstance().logError("Unable to parse view type as a visualID number: " + type);
            }
            return -1;
        }
    }

    public static String getType(int visualID) {
        return String.valueOf(visualID);
    }

    public static int getDiagramVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        if (CsaPackage.eINSTANCE.getDocumentRoot().isSuperTypeOf(domainElement.eClass()) && CsaVisualIDRegistry.isDiagram((DocumentRoot)domainElement)) {
            return 1000;
        }
        return -1;
    }

    public static int getNodeVisualID(View containerView, EObject domainElement) {
        int containerVisualID;
        if (domainElement == null) {
            return -1;
        }
        String containerModelID = CsaVisualIDRegistry.getModelID(containerView);
        if (!"Csa".equals(containerModelID)) {
            return -1;
        }
        if ("Csa".equals(containerModelID)) {
            containerVisualID = CsaVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 1000;
        } else {
            return -1;
        }
        switch (containerVisualID) {
            case 7001: {
                if (!CsaPackage.eINSTANCE.getService().isSuperTypeOf(domainElement.eClass())) break;
                return 3001;
            }
            case 7002: {
                if (!CsaPackage.eINSTANCE.getReference().isSuperTypeOf(domainElement.eClass())) break;
                return 3009;
            }
            case 7003: {
                if (!CsaPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass())) break;
                return 3017;
            }
            case 7004: {
                if (!CsaPackage.eINSTANCE.getComponent().isSuperTypeOf(domainElement.eClass())) break;
                return 3018;
            }
            case 7005: {
                if (CsaPackage.eINSTANCE.getJavaInterface().isSuperTypeOf(domainElement.eClass())) {
                    return 3002;
                }
                if (CsaPackage.eINSTANCE.getWSDLPortType().isSuperTypeOf(domainElement.eClass())) {
                    return 3003;
                }
                if (!CsaPackage.eINSTANCE.getCPPInterface().isSuperTypeOf(domainElement.eClass())) break;
                return 3004;
            }
            case 7006: {
                if (CsaPackage.eINSTANCE.getSCABinding().isSuperTypeOf(domainElement.eClass())) {
                    return 3005;
                }
                if (CsaPackage.eINSTANCE.getWebServiceBinding().isSuperTypeOf(domainElement.eClass())) {
                    return 3006;
                }
                if (CsaPackage.eINSTANCE.getEJBSessionBeanBinding().isSuperTypeOf(domainElement.eClass())) {
                    return 3007;
                }
                if (!CsaPackage.eINSTANCE.getJMSBinding().isSuperTypeOf(domainElement.eClass())) break;
                return 3008;
            }
            case 7007: {
                if (CsaPackage.eINSTANCE.getJavaInterface().isSuperTypeOf(domainElement.eClass())) {
                    return 3010;
                }
                if (CsaPackage.eINSTANCE.getWSDLPortType().isSuperTypeOf(domainElement.eClass())) {
                    return 3011;
                }
                if (!CsaPackage.eINSTANCE.getCPPInterface().isSuperTypeOf(domainElement.eClass())) break;
                return 3012;
            }
            case 7008: {
                if (CsaPackage.eINSTANCE.getSCABinding().isSuperTypeOf(domainElement.eClass())) {
                    return 3013;
                }
                if (CsaPackage.eINSTANCE.getWebServiceBinding().isSuperTypeOf(domainElement.eClass())) {
                    return 3014;
                }
                if (CsaPackage.eINSTANCE.getEJBSessionBeanBinding().isSuperTypeOf(domainElement.eClass())) {
                    return 3015;
                }
                if (!CsaPackage.eINSTANCE.getJMSBinding().isSuperTypeOf(domainElement.eClass())) break;
                return 3016;
            }
            case 7009: {
                if (!CsaPackage.eINSTANCE.getComponentService().isSuperTypeOf(domainElement.eClass())) break;
                return 3019;
            }
            case 7010: {
                if (CsaPackage.eINSTANCE.getJavaImplementation().isSuperTypeOf(domainElement.eClass())) {
                    return 3036;
                }
                if (CsaPackage.eINSTANCE.getSCAImplementation().isSuperTypeOf(domainElement.eClass())) {
                    return 3037;
                }
                if (CsaPackage.eINSTANCE.getBPELImplementation().isSuperTypeOf(domainElement.eClass())) {
                    return 3038;
                }
                if (CsaPackage.eINSTANCE.getCPPImplementation().isSuperTypeOf(domainElement.eClass())) {
                    return 3039;
                }
                if (CsaPackage.eINSTANCE.getEJBImplementation().isSuperTypeOf(domainElement.eClass())) {
                    return 3040;
                }
                if (CsaPackage.eINSTANCE.getSpringImplementation().isSuperTypeOf(domainElement.eClass())) {
                    return 3041;
                }
                if (!CsaPackage.eINSTANCE.getWebImplementation().isSuperTypeOf(domainElement.eClass())) break;
                return 3042;
            }
            case 7011: {
                if (!CsaPackage.eINSTANCE.getComponentReference().isSuperTypeOf(domainElement.eClass())) break;
                return 3027;
            }
            case 7012: {
                if (!CsaPackage.eINSTANCE.getPropertyValue().isSuperTypeOf(domainElement.eClass())) break;
                return 3035;
            }
            case 7013: {
                if (CsaPackage.eINSTANCE.getJavaInterface().isSuperTypeOf(domainElement.eClass())) {
                    return 3020;
                }
                if (CsaPackage.eINSTANCE.getWSDLPortType().isSuperTypeOf(domainElement.eClass())) {
                    return 3021;
                }
                if (!CsaPackage.eINSTANCE.getCPPInterface().isSuperTypeOf(domainElement.eClass())) break;
                return 3022;
            }
            case 7014: {
                if (CsaPackage.eINSTANCE.getSCABinding().isSuperTypeOf(domainElement.eClass())) {
                    return 3023;
                }
                if (CsaPackage.eINSTANCE.getWebServiceBinding().isSuperTypeOf(domainElement.eClass())) {
                    return 3024;
                }
                if (CsaPackage.eINSTANCE.getEJBSessionBeanBinding().isSuperTypeOf(domainElement.eClass())) {
                    return 3025;
                }
                if (!CsaPackage.eINSTANCE.getJMSBinding().isSuperTypeOf(domainElement.eClass())) break;
                return 3026;
            }
            case 7015: {
                if (CsaPackage.eINSTANCE.getJavaInterface().isSuperTypeOf(domainElement.eClass())) {
                    return 3028;
                }
                if (CsaPackage.eINSTANCE.getWSDLPortType().isSuperTypeOf(domainElement.eClass())) {
                    return 3029;
                }
                if (!CsaPackage.eINSTANCE.getCPPInterface().isSuperTypeOf(domainElement.eClass())) break;
                return 3030;
            }
            case 7016: {
                if (CsaPackage.eINSTANCE.getSCABinding().isSuperTypeOf(domainElement.eClass())) {
                    return 3031;
                }
                if (CsaPackage.eINSTANCE.getWebServiceBinding().isSuperTypeOf(domainElement.eClass())) {
                    return 3032;
                }
                if (CsaPackage.eINSTANCE.getEJBSessionBeanBinding().isSuperTypeOf(domainElement.eClass())) {
                    return 3033;
                }
                if (!CsaPackage.eINSTANCE.getJMSBinding().isSuperTypeOf(domainElement.eClass())) break;
                return 3034;
            }
            case 1000: {
                if (!CsaPackage.eINSTANCE.getComposite().isSuperTypeOf(domainElement.eClass())) break;
                return 2001;
            }
        }
        return -1;
    }

    public static boolean canCreateNode(View containerView, int nodeVisualID) {
        int containerVisualID;
        String containerModelID = CsaVisualIDRegistry.getModelID(containerView);
        if (!"Csa".equals(containerModelID)) {
            return false;
        }
        if ("Csa".equals(containerModelID)) {
            containerVisualID = CsaVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 1000;
        } else {
            return false;
        }
        switch (containerVisualID) {
            case 2001: {
                if (5008 == nodeVisualID) {
                    return true;
                }
                if (7001 == nodeVisualID) {
                    return true;
                }
                if (7002 == nodeVisualID) {
                    return true;
                }
                if (7003 == nodeVisualID) {
                    return true;
                }
                if (7004 != nodeVisualID) break;
                return true;
            }
            case 3001: {
                if (5001 == nodeVisualID) {
                    return true;
                }
                if (7005 == nodeVisualID) {
                    return true;
                }
                if (7006 != nodeVisualID) break;
                return true;
            }
            case 3009: {
                if (5002 == nodeVisualID) {
                    return true;
                }
                if (7007 == nodeVisualID) {
                    return true;
                }
                if (7008 != nodeVisualID) break;
                return true;
            }
            case 3017: {
                if (5003 != nodeVisualID) break;
                return true;
            }
            case 3018: {
                if (5007 == nodeVisualID) {
                    return true;
                }
                if (7009 == nodeVisualID) {
                    return true;
                }
                if (7010 == nodeVisualID) {
                    return true;
                }
                if (7011 == nodeVisualID) {
                    return true;
                }
                if (7012 != nodeVisualID) break;
                return true;
            }
            case 3019: {
                if (5004 == nodeVisualID) {
                    return true;
                }
                if (7013 == nodeVisualID) {
                    return true;
                }
                if (7014 != nodeVisualID) break;
                return true;
            }
            case 3027: {
                if (5005 == nodeVisualID) {
                    return true;
                }
                if (7015 == nodeVisualID) {
                    return true;
                }
                if (7016 != nodeVisualID) break;
                return true;
            }
            case 3035: {
                if (5006 != nodeVisualID) break;
                return true;
            }
            case 7001: {
                if (3001 != nodeVisualID) break;
                return true;
            }
            case 7002: {
                if (3009 != nodeVisualID) break;
                return true;
            }
            case 7003: {
                if (3017 != nodeVisualID) break;
                return true;
            }
            case 7004: {
                if (3018 != nodeVisualID) break;
                return true;
            }
            case 7005: {
                if (3002 == nodeVisualID) {
                    return true;
                }
                if (3003 == nodeVisualID) {
                    return true;
                }
                if (3004 != nodeVisualID) break;
                return true;
            }
            case 7006: {
                if (3005 == nodeVisualID) {
                    return true;
                }
                if (3006 == nodeVisualID) {
                    return true;
                }
                if (3007 == nodeVisualID) {
                    return true;
                }
                if (3008 != nodeVisualID) break;
                return true;
            }
            case 7007: {
                if (3010 == nodeVisualID) {
                    return true;
                }
                if (3011 == nodeVisualID) {
                    return true;
                }
                if (3012 != nodeVisualID) break;
                return true;
            }
            case 7008: {
                if (3013 == nodeVisualID) {
                    return true;
                }
                if (3014 == nodeVisualID) {
                    return true;
                }
                if (3015 == nodeVisualID) {
                    return true;
                }
                if (3016 != nodeVisualID) break;
                return true;
            }
            case 7009: {
                if (3019 != nodeVisualID) break;
                return true;
            }
            case 7010: {
                if (3036 == nodeVisualID) {
                    return true;
                }
                if (3037 == nodeVisualID) {
                    return true;
                }
                if (3038 == nodeVisualID) {
                    return true;
                }
                if (3039 == nodeVisualID) {
                    return true;
                }
                if (3040 == nodeVisualID) {
                    return true;
                }
                if (3041 == nodeVisualID) {
                    return true;
                }
                if (3042 != nodeVisualID) break;
                return true;
            }
            case 7011: {
                if (3027 != nodeVisualID) break;
                return true;
            }
            case 7012: {
                if (3035 != nodeVisualID) break;
                return true;
            }
            case 7013: {
                if (3020 == nodeVisualID) {
                    return true;
                }
                if (3021 == nodeVisualID) {
                    return true;
                }
                if (3022 != nodeVisualID) break;
                return true;
            }
            case 7014: {
                if (3023 == nodeVisualID) {
                    return true;
                }
                if (3024 == nodeVisualID) {
                    return true;
                }
                if (3025 == nodeVisualID) {
                    return true;
                }
                if (3026 != nodeVisualID) break;
                return true;
            }
            case 7015: {
                if (3028 == nodeVisualID) {
                    return true;
                }
                if (3029 == nodeVisualID) {
                    return true;
                }
                if (3030 != nodeVisualID) break;
                return true;
            }
            case 7016: {
                if (3031 == nodeVisualID) {
                    return true;
                }
                if (3032 == nodeVisualID) {
                    return true;
                }
                if (3033 == nodeVisualID) {
                    return true;
                }
                if (3034 != nodeVisualID) break;
                return true;
            }
            case 1000: {
                if (2001 != nodeVisualID) break;
                return true;
            }
        }
        return false;
    }

    public static int getLinkWithClassVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        if (CsaPackage.eINSTANCE.getWire().isSuperTypeOf(domainElement.eClass())) {
            return 4003;
        }
        return -1;
    }

    private static boolean isDiagram(DocumentRoot element) {
        return true;
    }
}

