/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.csa.diagram.router.lib;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;

public final class ConnectionUtils {
    private ConnectionUtils() {
    }

    public static PointList getRoundedRectilinearSmoothPoints(boolean isDuringDrag, PointList points, int smoothness) {
        if (smoothness < 10 || points.size() == 0) {
            return points;
        }
        double PREFERRED_RADIUS = smoothness < 20 ? 8.0 : (smoothness < 25 ? 12.0 : (smoothness < 35 ? 16.0 : 22.0));
        PointList newPoints = new PointList();
        newPoints.addPoint(points.getFirstPoint());
        int i = 1;
        while (i < points.size() - 1) {
            double startAngle;
            boolean centerIsTop;
            double centerX;
            Point prev = points.getPoint(i - 1);
            Point curr = points.getPoint(i);
            Point next = points.getPoint(i + 1);
            boolean reverse = false;
            if (prev.x - next.x > 2) {
                prev = next;
                next = points.getPoint(i - 1);
                reverse = true;
            }
            double halfSeg1 = curr.getDistance(prev) / 2.0;
            double halfSeg2 = curr.getDistance(next) / 2.0;
            double radius = Math.min(halfSeg1, halfSeg2);
            radius = Math.min(radius, PREFERRED_RADIUS);
            boolean centerIsLeft = curr.x - prev.x > 2;
            int direction = 1;
            if (centerIsLeft) {
                centerX = (double)curr.x - radius;
                centerIsTop = next.y < prev.y;
            } else {
                centerX = (double)curr.x + radius;
                centerIsTop = next.y > prev.y;
            }
            double centerY = centerIsTop ? (double)curr.y - radius : (double)curr.y + radius;
            if (centerIsTop) {
                direction = -1;
                startAngle = centerIsLeft ? -90.0 : 0.0;
            } else {
                direction = 1;
                startAngle = centerIsLeft ? 90.0 : 0.0;
            }
            int pointsCount = 5;
            double deltaAngle = 90.0 / (double)pointsCount;
            PointList pl = reverse ? new PointList() : null;
            int k = 0;
            while (k <= pointsCount) {
                double angle = Math.toRadians(startAngle + (double)direction * deltaAngle * (double)k);
                double x = centerX - radius * Math.cos(angle);
                double y = centerY - radius * Math.sin(angle);
                if (reverse) {
                    pl.addPoint((Point)new PrecisionPoint(x, y));
                } else {
                    newPoints.addPoint((Point)new PrecisionPoint(x, y));
                }
                ++k;
            }
            if (reverse) {
                pl.reverse();
                newPoints.addAll(pl);
            }
            ++i;
        }
        newPoints.addPoint(points.getLastPoint());
        return newPoints;
    }
}

