/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.csa.introspection;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Iterator;
import org.eclipse.stp.sca.csa.Component;
import org.eclipse.stp.sca.csa.Composite;
import org.osoa.sca.annotations.Reference;

public class IntrospectionUtils {
    public static Component getComponent(Composite composite, String componentName) {
        Component component = null;
        boolean found = false;
        Iterator it = composite.getComponent().iterator();
        while (!found && it.hasNext()) {
            component = (Component)it.next();
            if (!component.getName().equals(componentName)) continue;
            found = true;
        }
        return component;
    }

    public static String getReferenceName(AccessibleObject object) {
        if (object instanceof Field) {
            Field field = (Field)object;
            String name = field.getAnnotation(Reference.class).name();
            if (name.equals("")) {
                name = field.getName();
            }
            return name;
        }
        if (object instanceof Method) {
            Method method = (Method)object;
            String name = method.getAnnotation(Reference.class).name();
            if (method.getName().startsWith("get")) {
                return null;
            }
            if (name.equals("")) {
                if (method.getName().startsWith("set")) {
                    name = method.getName().substring(3);
                    name = String.valueOf(name.substring(0, 1).toLowerCase()) + name.substring(1, name.length());
                } else {
                    name = method.getName();
                    name = String.valueOf(name.substring(0, 1).toLowerCase()) + name.substring(1, name.length());
                }
            }
            return name;
        }
        return null;
    }
}

