/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.csa.introspection.metadata;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.stp.sca.csa.introspection.metadata.Messages;
import org.eclipse.stp.sca.csa.introspection.metadata.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaData<T> {
    private Class<T> cl;
    private List<Object> clmd = new ArrayList<Object>();
    private Map<Constructor<?>, List<Object>> ctormd = new HashMap();
    private Map<Field, List<Object>> fieldmd = new HashMap<Field, List<Object>>();
    private Map<Method, List<Object>> methmd = new HashMap<Method, List<Object>>();

    public MetaData(Class<T> cl) {
        this.cl = cl;
    }

    public Class<T> getSupportClass() {
        return this.cl;
    }

    public String toString() {
        return this.cl.getName();
    }

    public <A extends Annotation> A getAnnotation(Class<A> annotcl) {
        List<Object> mds = this.getMetaData();
        for (Object md : mds) {
            if (!annotcl.isAssignableFrom(md.getClass())) continue;
            Annotation annot2 = (Annotation)md;
            return (A)annot2;
        }
        A annot = this.cl.getAnnotation(annotcl);
        if (annot != null) {
            return annot;
        }
        return null;
    }

    public Object[] getAnnotations() {
        Annotation[] annots;
        List<Object> mds = this.getMetaData();
        mds = new ArrayList<Object>(mds);
        Annotation[] annotationArray = annots = this.cl.getAnnotations();
        int n = annots.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annot = annotationArray[n2];
            Class<?> annotcl = annot.getClass();
            boolean exists = false;
            for (Object md : mds) {
                Class<?> cl = md.getClass();
                if (!cl.equals(annotcl)) continue;
                exists = true;
            }
            if (!exists) {
                mds.add(annot);
            }
            ++n2;
        }
        Object[] all = mds.toArray();
        return all;
    }

    public Field[] getAllAnnotatedFields(Class<? extends Annotation> annotcl) {
        Field field;
        Field[] fields;
        ArrayList<Field> result = new ArrayList<Field>();
        Field[] fieldArray = fields = this.cl.getDeclaredFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            field = fieldArray[n2];
            if (field.getAnnotation(annotcl) != null) {
                result.add(field);
            } else {
                List<Object> mds = this.getMetaData(field);
                if (mds != null) {
                    for (Object md : mds) {
                        if (!annotcl.isAssignableFrom(md.getClass())) continue;
                        result.add(field);
                    }
                }
            }
            ++n2;
        }
        fieldArray = fields = this.cl.getFields();
        n = fields.length;
        n2 = 0;
        while (n2 < n) {
            field = fieldArray[n2];
            if (!result.contains(field) && field.getAnnotation(annotcl) != null) {
                result.add(field);
            }
            ++n2;
        }
        return result.toArray(new Field[result.size()]);
    }

    public Method[] getAllAnnotatedMethods(Class<? extends Annotation> annotcl) {
        Method method;
        Method[] methods;
        ArrayList<Method> result = new ArrayList<Method>();
        Method[] methodArray = methods = this.cl.getDeclaredMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            method = methodArray[n2];
            if (method.getAnnotation(annotcl) != null) {
                result.add(method);
            } else {
                List<Object> mds = this.getMetaData(method);
                if (mds != null) {
                    for (Object md : mds) {
                        if (!annotcl.isAssignableFrom(md.getClass())) continue;
                        result.add(method);
                    }
                }
            }
            ++n2;
        }
        methodArray = methods = this.cl.getMethods();
        n = methods.length;
        n2 = 0;
        while (n2 < n) {
            method = methodArray[n2];
            if (!result.contains(method) && method.getAnnotation(annotcl) != null) {
                result.add(method);
            }
            ++n2;
        }
        return result.toArray(new Method[result.size()]);
    }

    public AccessibleObject[] getAllAnnotatedMethodsAndFields(Class<? extends Annotation> annotcl) {
        Method[] methods = this.getAllAnnotatedMethods(annotcl);
        Field[] fields = this.getAllAnnotatedFields(annotcl);
        AccessibleObject[] result = new AccessibleObject[methods.length + fields.length];
        System.arraycopy(methods, 0, result, 0, methods.length);
        System.arraycopy(fields, 0, result, methods.length, fields.length);
        return result;
    }

    public Map<String, Method> getAllUnAnnotatedSetterMethods() {
        String prop;
        Annotation[] annots;
        Method method;
        Method[] methods;
        HashMap<String, Method> result = new HashMap<String, Method>();
        Method[] methodArray = methods = this.cl.getDeclaredMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            method = methodArray[n2];
            if (Util.isSetterMethod(method) && (annots = method.getAnnotations()).length == 0) {
                prop = Util.getPropertyName(method);
                if (result.containsKey(prop)) {
                    String msg = String.valueOf(Messages.MetaData_0) + this.cl.getName() + Messages.MetaData_1 + prop;
                    throw new UnsupportedOperationException(msg);
                }
                result.put(prop, method);
            }
            ++n2;
        }
        methodArray = methods = this.cl.getMethods();
        n = methods.length;
        n2 = 0;
        while (n2 < n) {
            method = methodArray[n2];
            if (Util.isSetterMethod(method) && (annots = method.getAnnotations()).length == 0) {
                prop = Util.getPropertyName(method);
                if (result.containsKey(prop) && !result.containsValue(method)) {
                    String msg = String.valueOf(Messages.MetaData_2) + this.cl.getName() + Messages.MetaData_3 + prop;
                    throw new UnsupportedOperationException(msg);
                }
                result.put(prop, method);
            }
            ++n2;
        }
        return result;
    }

    public Constructor<?>[] getDeclaredAnnotatedConstructors(Class<? extends Annotation> annotcl) {
        Constructor<?>[] constructors;
        ArrayList result = new ArrayList();
        Constructor<?>[] constructorArray = constructors = this.cl.getDeclaredConstructors();
        int n = constructors.length;
        int n2 = 0;
        while (n2 < n) {
            Constructor<?> constructor = constructorArray[n2];
            if (constructor.getAnnotation(annotcl) != null) {
                result.add(constructor);
            } else {
                List<Object> mds = this.getMetaData(constructor);
                if (mds != null) {
                    for (Object md : mds) {
                        if (!annotcl.isAssignableFrom(md.getClass())) continue;
                        result.add(constructor);
                    }
                }
            }
            ++n2;
        }
        return result.toArray(new Constructor[result.size()]);
    }

    public void addMetaData(Object md) {
        this.clmd.add(md);
    }

    public void addMetaData(Constructor<?> c, Object md) {
        this.checkOwnership(c);
        List<Object> mds = this.ctormd.get(c);
        if (mds == null) {
            mds = new ArrayList<Object>();
            this.ctormd.put(c, mds);
        }
        mds.add(md);
    }

    public void addMetaData(Field f, Object md) {
        this.checkOwnership(f);
        List<Object> mds = this.fieldmd.get(f);
        if (mds == null) {
            mds = new ArrayList<Object>();
            this.fieldmd.put(f, mds);
        }
        mds.add(md);
    }

    public void addMetaData(Method m, Object md) {
        this.checkOwnership(m);
        List<Object> mds = this.methmd.get(m);
        if (mds == null) {
            mds = new ArrayList<Object>();
            this.methmd.put(m, mds);
        }
        mds.add(md);
    }

    public boolean containsMetaData() {
        boolean b = !this.clmd.isEmpty();
        return b;
    }

    public boolean containsMetaData(Constructor<?> c) {
        this.checkOwnership(c);
        boolean b = this.ctormd.containsKey(c);
        return b;
    }

    public boolean containsMetaData(Field f) {
        this.checkOwnership(f);
        boolean b = this.fieldmd.containsKey(f);
        return b;
    }

    public boolean containsMetaData(Method m) {
        this.checkOwnership(m);
        boolean b = this.methmd.containsKey(m);
        return b;
    }

    public List<Object> getMetaData() {
        return this.clmd;
    }

    public List<Object> getMetaData(Constructor<?> c) {
        this.checkOwnership(c);
        List<Object> ret = this.ctormd.get(c);
        return ret;
    }

    public List<Object> getMetaData(Field f) {
        this.checkOwnership(f);
        List<Object> ret = this.fieldmd.get(f);
        return ret;
    }

    public List<Object> getMetaData(Method m) {
        this.checkOwnership(m);
        List<Object> ret = this.methmd.get(m);
        return ret;
    }

    private void checkOwnership(Member member) throws IllegalArgumentException {
        Class<?> declaringClass = member.getDeclaringClass();
        if (!this.cl.equals(declaringClass)) {
            String msg = member + Messages.MetaData_4 + this.cl.getName();
            throw new IllegalArgumentException(msg);
        }
    }
}

