/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.deployment;

import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.Parameterization;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;

public class Utils {
    public static void openConfigurations(String mode) {
        ICommandService cmdService = (ICommandService)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getService(ICommandService.class);
        String command = mode.equalsIgnoreCase("run") ? "org.eclipse.debug.ui.commands.OpenRunConfigurations" : "org.eclipse.debug.ui.commands.OpenDebugConfigurations";
        Command openConfig = cmdService.getCommand(command);
        try {
            ParameterizedCommand parmCommand = new ParameterizedCommand(openConfig, new Parameterization[0]);
            IHandlerService ds = (IHandlerService)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getService(IHandlerService.class);
            ds.executeCommand(parmCommand, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String createScaLaunchConfigurationName(IFile compositeFile, String masterConfigName) {
        return String.valueOf(compositeFile.getProjectRelativePath().removeFileExtension().lastSegment()) + " - " + masterConfigName;
    }

    public static boolean isConcreteConfigurationFrom(String masterConfigName, String concreteConfigName) {
        return concreteConfigName.endsWith(" - " + masterConfigName);
    }

    public static void updateScaLaunchConfigurationName(String previousMasterConfigName, String newMasterConfigName) throws CoreException {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType launchConfigurationType = launchManager.getLaunchConfigurationType("org.eclipse.stp.sca.deployment.scaLaunchConfiguration");
        ILaunchConfiguration[] iLaunchConfigurationArray = launchManager.getLaunchConfigurations(launchConfigurationType);
        int n = iLaunchConfigurationArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfiguration c = iLaunchConfigurationArray[n2];
            if (c.getName().endsWith(" - " + previousMasterConfigName)) {
                String name = c.getName().replaceAll(String.valueOf(previousMasterConfigName) + "$", newMasterConfigName);
                ILaunchConfigurationWorkingCopy wc = c.copy(name);
                wc.doSave();
                c.delete();
            }
            ++n2;
        }
    }
}

