/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.diagram.common.contenttype;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.content.IContentDescriber;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.stp.sca.diagram.common.ScaDiagramCommonPlugin;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class GMFContentDescriber
implements IContentDescriber,
IExecutableExtension {
    private static final QualifiedName[] SUPPORTED_OPTIONS = new QualifiedName[]{IContentDescription.CHARSET, IContentDescription.BYTE_ORDER_MARK};
    private String elementToFind;

    private boolean isFound(Document doc) {
        boolean found = false;
        NodeList children = doc.getChildNodes();
        int i = 0;
        while (i < children.getLength() && !found) {
            if (children.item(i) instanceof Element) {
                Element e = (Element)children.item(i);
                NamedNodeMap map = e.getAttributes();
                int ii = 0;
                while (ii < map.getLength() && !found) {
                    found = this.elementToFind.equals(map.item(ii).getNodeValue());
                    ++ii;
                }
            }
            ++i;
        }
        return found;
    }

    public int describe(InputSource contents, IContentDescription description) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setValidating(false);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(contents);
            if (this.isFound(doc)) {
                return 2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    public int describe(InputStream contents, IContentDescription description) throws IOException {
        return this.describe(new InputSource(contents), description);
    }

    public int describe(Reader contents, IContentDescription description) {
        return this.describe(new InputSource(contents), description);
    }

    public QualifiedName[] getSupportedOptions() {
        return SUPPORTED_OPTIONS;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        if (data instanceof String) {
            this.elementToFind = (String)data;
        } else if (data instanceof Hashtable) {
            IConfigurationElement describerElement = config.getChildren("describer")[0];
            IConfigurationElement[] params = describerElement.getChildren("parameter");
            String pname = null;
            int i = 0;
            while (i < params.length) {
                pname = params[i].getAttribute("name");
                if ("namespace".equals(pname)) {
                    this.elementToFind = params[i].getAttribute("value");
                }
                ++i;
            }
        }
        if (this.elementToFind == null) {
            String msg = "Bad initialization data";
            IllegalStateException e = new IllegalStateException("namespace value not set");
            ScaDiagramCommonPlugin.logError(msg, e);
            throw e;
        }
    }
}

