/*
 * Copyright (c) 2007-2008-2009-2010 Obeo
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Obeo - initial API and implementation
 */
package org.eclipse.stp.sca.semantic.sawsdl.properties;

import org.eclipse.emf.ecore.EReference;
import org.eclipse.stp.sca.AnyExtension;
import org.eclipse.stp.sca.diagram.providers.ScaPropertySectionProvider;

import sawsdl.SAWSDL;
import sawsdl.SawsdlFactory;
import sawsdl.SawsdlPackage;

/**
 * @author Stephane Drapeau - Obeo
 */
public class SawsdlPropertySectionProvider extends ScaPropertySectionProvider {

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * org.eclipse.stp.sca.diagram.providers.ScaPropertySectionProvider#getType
	 * ()
	 */
	@Override
	protected Class getType() {
		return SAWSDL.class;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @seeorg.eclipse.stp.sca.diagram.providers.ScaPropertySectionProvider#
	 * createElement()
	 */
	@Override
	protected AnyExtension createElement() {
		return SawsdlFactory.eINSTANCE.createSAWSDL();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @seeorg.eclipse.stp.sca.diagram.providers.ScaPropertySectionProvider#
	 * getMetaObjectLiteral()
	 */
	@Override
	protected EReference getMetaObjectLiteral() {
		return SawsdlPackage.Literals.DOCUMENT_ROOT__SAWSDL;
	}
}
