/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.xmleditor.completion;

import java.util.regex.Pattern;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public abstract class AbstractProcessor
implements IContentAssistProcessor {
    protected String markupName;
    protected String attributeValue;
    protected String attributeName = null;
    protected String textAfterOffset;
    protected Element element;
    protected IDocument document;
    protected int offset;
    private final Pattern SINGLE_MARKUP_PATTERN = Pattern.compile("^< [^<>]+ />$", 36);
    private final Pattern DOUBLE_MARKUP_PATTERN = Pattern.compile("^< [^<>]+ > .* </ [^<>]+ >$", 36);

    public final ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        IStructuredModel model = StructuredModelManager.getModelManager().getExistingModelForRead(viewer.getDocument());
        return this.computeCompletionProposals(model, offset);
    }

    public ICompletionProposal[] computeCompletionProposals(IStructuredModel model, int offset) {
        IndexedRegion indexedRegion = model.getIndexedRegion(offset);
        if (indexedRegion == null) {
            indexedRegion = model.getIndexedRegion(offset - 1);
        }
        ICompletionProposal[] result = new ICompletionProposal[]{};
        if (indexedRegion != null) {
            int previousOffet;
            this.offset = offset;
            this.document = model.getStructuredDocument();
            if (indexedRegion instanceof Element) {
                this.element = (Element)indexedRegion;
                Location location = this.computeContext(indexedRegion);
                result = this.computeCompletionProposals(location);
            } else if (indexedRegion instanceof Text && (previousOffet = indexedRegion.getStartOffset() - 1) > 0 && (indexedRegion = model.getIndexedRegion(previousOffet)) != null && indexedRegion instanceof Element) {
                try {
                    int length = indexedRegion.getEndOffset() - indexedRegion.getStartOffset();
                    String elementText = this.document.get(indexedRegion.getStartOffset(), length);
                    elementText = elementText.trim();
                    elementText = elementText.replace('\n', ' ');
                    elementText = elementText.replace('\r', ' ');
                    this.element = (Element)indexedRegion;
                    if (this.SINGLE_MARKUP_PATTERN.matcher(elementText).find() || this.DOUBLE_MARKUP_PATTERN.matcher(elementText).find()) {
                        this.element = (Element)this.element.getParentNode();
                    }
                    Location location = Location.afterElement;
                    result = this.computeCompletionProposals(location);
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    protected Location computeContext(IndexedRegion indexedRegion) {
        StringBuffer buf;
        String textBefore = "";
        try {
            textBefore = this.document.get(indexedRegion.getStartOffset(), this.offset - indexedRegion.getStartOffset());
            buf = new StringBuffer();
            char c = 'a';
            int i = this.offset;
            while (this.offset < indexedRegion.getEndOffset() && c != '\"') {
                c = this.document.getChar(i);
                buf.append(c);
                ++i;
            }
            this.textAfterOffset = buf.toString();
        }
        catch (BadLocationException e) {
            return Location.somewhereElse;
        }
        buf = null;
        int quoteChar = 97;
        Location location = Location.somewhereElse;
        int i = 0;
        while (i < textBefore.length()) {
            char c = textBefore.charAt(i);
            if (c == '<') {
                location = Location.inElement;
                buf = new StringBuffer();
            } else if (c == '\'' || c == '\"') {
                if (quoteChar != 39 && quoteChar != 34) {
                    quoteChar = c;
                    location = Location.inAttributeValue;
                    buf = new StringBuffer();
                } else {
                    quoteChar = 97;
                    buf = null;
                    location = Location.somewhereElse;
                }
            } else if (location == Location.somewhereElse) {
                if (!Character.isWhitespace(c)) {
                    location = Location.inAttributeName;
                    buf = new StringBuffer();
                    buf.append(c);
                } else {
                    this.attributeName = null;
                    this.attributeValue = null;
                }
            } else if (c != '=' && !Character.isWhitespace(c)) {
                buf.append(c);
            } else {
                if (location == Location.inElement) {
                    this.markupName = buf.toString();
                } else if (location == Location.inAttributeName) {
                    this.attributeName = buf.toString();
                } else {
                    this.attributeValue = buf.toString();
                }
                buf = null;
                location = Location.somewhereElse;
            }
            ++i;
        }
        if (location == Location.inElement) {
            this.markupName = buf.toString();
        } else if (location == Location.inAttributeName) {
            this.attributeName = buf.toString();
        } else if (location == Location.inAttributeValue) {
            this.attributeValue = buf.toString();
        }
        return location;
    }

    protected abstract ICompletionProposal[] computeCompletionProposals(Location var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum Location {
        inElement,
        inAttributeName,
        inAttributeValue,
        afterElement,
        somewhereElse;

    }
}

