/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.xmleditor.completion;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.stp.sca.common.utils.DomUtils;
import org.eclipse.stp.sca.common.utils.ResourceUtils;
import org.eclipse.stp.sca.xmleditor.completion.AbstractProcessor;
import org.eclipse.stp.sca.xmleditor.utils.IncludesUtils;
import org.eclipse.stp.sca.xmleditor.utils.ScaUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeValueProcessor
extends AbstractProcessor {
    private IFile editedFile;
    private IncludesUtils includesUtils;
    private final Map<String, String> generatedNsUriToPrefix = new HashMap<String, String>();

    @Override
    public ICompletionProposal[] computeCompletionProposals(AbstractProcessor.Location location) {
        int index;
        if (this.editedFile == null) {
            this.initializeInclusionElements();
        }
        if (this.markupName == null || this.attributeName == null || location == AbstractProcessor.Location.afterElement) {
            return new ICompletionProposal[0];
        }
        if (location != AbstractProcessor.Location.inAttributeValue) {
            return new ICompletionProposal[0];
        }
        if (this.attributeValue == null) {
            this.attributeValue = "";
        }
        StringBuffer buf = new StringBuffer();
        int j = 0;
        while (j < this.textAfterOffset.length()) {
            char c = this.textAfterOffset.charAt(j);
            if (c == '\'' || c == '\"' || c == '>' || c == '\n' || c == '\r') break;
            buf.append(c);
            ++j;
        }
        if ((index = this.markupName.lastIndexOf(58)) >= 0) {
            this.markupName = index < this.markupName.length() - 1 ? this.markupName.substring(index + 1) : "";
        }
        return this.makeProposals(this.markupName, this.attributeName, this.attributeValue, buf.toString());
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return new IContextInformation[0];
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return new char[]{'/', ':'};
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return new char[0];
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    private void initializeInclusionElements() {
        this.editedFile = ResourceUtils.getIFileFromEditor();
        IProject project = this.editedFile.getProject();
        this.includesUtils = IncludesUtils.createIncludesUtils(project);
    }

    public ICompletionProposal[] makeProposals(String markupName, String attributeName, String attributeValue, String remainingAttributeValue) {
        if ("service".equalsIgnoreCase(markupName)) {
            return this.provideServiceMarkupProposals(attributeName, attributeValue, remainingAttributeValue);
        }
        if ("reference".equalsIgnoreCase(markupName)) {
            return this.provideReferenceMarkupProposals(attributeName, attributeValue, remainingAttributeValue);
        }
        if ("wire".equalsIgnoreCase(markupName)) {
            return this.provideWireMarkupProposals(attributeName, attributeValue, remainingAttributeValue);
        }
        if ("include".equalsIgnoreCase(markupName)) {
            return this.provideIncludesMarkupProposals(attributeName, attributeValue, remainingAttributeValue);
        }
        return new ICompletionProposal[0];
    }

    private ICompletionProposal[] provideWireMarkupProposals(String attributeName, String attributeValue, String remainingAttributeValue) {
        if ("source".equalsIgnoreCase(attributeName)) {
            String[] referenceNames = ScaUtils.getPromotions(this.element.getOwnerDocument(), false);
            ArrayList<CompletionProposal> result = new ArrayList<CompletionProposal>();
            String[] stringArray = referenceNames;
            int n = referenceNames.length;
            int n2 = 0;
            while (n2 < n) {
                String referenceName = stringArray[n2];
                if (referenceName.startsWith(attributeValue)) {
                    int replacementLength = attributeValue.length() + remainingAttributeValue.length();
                    result.add(new CompletionProposal(referenceName, this.offset - attributeValue.length(), replacementLength, referenceName.length()));
                }
                ++n2;
            }
            ICompletionProposal[] proposals = new ICompletionProposal[result.size()];
            return result.toArray(proposals);
        }
        if ("target".equalsIgnoreCase(attributeName)) {
            String[] serviceNames = ScaUtils.getPromotions(this.element.getOwnerDocument(), true);
            ArrayList<CompletionProposal> result = new ArrayList<CompletionProposal>();
            String[] stringArray = serviceNames;
            int n = serviceNames.length;
            int n3 = 0;
            while (n3 < n) {
                String serviceName = stringArray[n3];
                if (serviceName.startsWith(attributeValue)) {
                    int replacementLength = attributeValue.length() + remainingAttributeValue.length();
                    result.add(new CompletionProposal(serviceName, this.offset - attributeValue.length(), replacementLength, serviceName.length()));
                }
                ++n3;
            }
            ICompletionProposal[] proposals = new ICompletionProposal[result.size()];
            return result.toArray(proposals);
        }
        return new ICompletionProposal[0];
    }

    private ICompletionProposal[] provideReferenceMarkupProposals(String attributeName, String attributeValue, String remainingAttributeValue) {
        String[] referenceNames = "promote".equalsIgnoreCase(attributeName) ? ScaUtils.getPromotions(this.element.getOwnerDocument(), false) : ("target".equalsIgnoreCase(attributeName) ? ScaUtils.getPromotions(this.element.getOwnerDocument(), true) : new String[]{});
        ArrayList<CompletionProposal> result = new ArrayList<CompletionProposal>();
        String[] stringArray = referenceNames;
        int n = referenceNames.length;
        int n2 = 0;
        while (n2 < n) {
            String referenceName = stringArray[n2];
            if (referenceName.startsWith(attributeValue)) {
                int replacementLength = attributeValue.length() + remainingAttributeValue.length();
                result.add(new CompletionProposal(referenceName, this.offset - attributeValue.length(), replacementLength, referenceName.length()));
            }
            ++n2;
        }
        ICompletionProposal[] proposals = new ICompletionProposal[result.size()];
        return result.toArray(proposals);
    }

    private ICompletionProposal[] provideServiceMarkupProposals(String attributeName, String attributeValue, String remainingAttributeValue) {
        String[] serviceNames = "promote".equalsIgnoreCase(attributeName) ? ScaUtils.getPromotions(this.element.getOwnerDocument(), true) : new String[]{};
        ArrayList<CompletionProposal> result = new ArrayList<CompletionProposal>();
        String[] stringArray = serviceNames;
        int n = serviceNames.length;
        int n2 = 0;
        while (n2 < n) {
            String serviceName = stringArray[n2];
            if (serviceName.startsWith(attributeValue)) {
                int replacementLength = attributeValue.length() + remainingAttributeValue.length();
                result.add(new CompletionProposal(serviceName, this.offset - attributeValue.length(), replacementLength, serviceName.length()));
            }
            ++n2;
        }
        ICompletionProposal[] proposals = new ICompletionProposal[result.size()];
        return result.toArray(proposals);
    }

    private List<QName> getIncludedFiles(Document domDoc) {
        ArrayList<QName> includeQNames = new ArrayList<QName>();
        NodeList includes = domDoc.getElementsByTagNameNS("*", "include");
        int i = 0;
        while (i < includes.getLength()) {
            QName includeQName = ScaUtils.getIncludeQName(includes.item(i));
            if (includeQName != null) {
                includeQNames.add(includeQName);
            }
            ++i;
        }
        return includeQNames;
    }

    private ICompletionProposal[] provideIncludesMarkupProposals(String attributeName, String attributeValue, String remainingAttributeValue) {
        try {
            this.initializeInclusionElements();
            List<QName> alreadyIncluded = this.getIncludedFiles(this.element.getOwnerDocument());
            QName currentQName = this.includesUtils.getQName(this.editedFile);
            if (currentQName != null) {
                alreadyIncluded.add(currentQName);
            }
            ArrayList<QName> possibleInclusions = new ArrayList<QName>(this.includesUtils.getQNames());
            possibleInclusions.removeAll(alreadyIncluded);
            ArrayList<CompletionProposal> proposals = new ArrayList<CompletionProposal>();
            for (QName qName : possibleInclusions) {
                String nsUri = qName.getNamespaceURI();
                String nsPrefix = this.element.lookupPrefix(nsUri);
                if (nsPrefix == null && (nsPrefix = this.generatedNsUriToPrefix.get(nsUri)) == null) {
                    nsPrefix = this.generateNamespacePrefix(nsUri, String.valueOf(attributeValue) + remainingAttributeValue);
                }
                String proposal = nsPrefix.length() == 0 ? qName.getLocalPart() : (this.generatedNsUriToPrefix.containsKey(nsUri) ? String.valueOf(nsPrefix) + ":" + qName.getLocalPart() + "\" xmlns:" + nsPrefix + "=\"" + qName.getNamespaceURI() : String.valueOf(nsPrefix) + ":" + qName.getLocalPart());
                if (!qName.getLocalPart().startsWith(attributeValue) && !nsPrefix.startsWith(attributeValue)) continue;
                int replacementLength = attributeValue.length() + remainingAttributeValue.length();
                proposals.add(new CompletionProposal(proposal, this.offset - attributeValue.length(), replacementLength, proposal.length(), null, qName.getLocalPart(), null, "<b>{" + qName.getNamespaceURI() + "}</b> " + qName.getLocalPart()));
            }
            ICompletionProposal[] result = new ICompletionProposal[proposals.size()];
            return proposals.toArray(result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ICompletionProposal[0];
        }
    }

    private String generateNamespacePrefix(String nsUri, String completeAttributeValue) {
        int num = this.generatedNsUriToPrefix.size();
        String nsPrefix = "include" + num;
        boolean correctPrefix = false;
        while (!correctPrefix) {
            String associatedUri = DomUtils.lookupNamespaceURI((String)nsPrefix, (Node)this.element);
            if (associatedUri != null) {
                if (!nsUri.equals(associatedUri)) {
                    nsPrefix = "include" + ++num;
                    continue;
                }
                correctPrefix = true;
                continue;
            }
            if (completeAttributeValue.startsWith(nsPrefix)) {
                nsPrefix = "include" + ++num;
                continue;
            }
            correctPrefix = true;
        }
        this.generatedNsUriToPrefix.put(nsUri, nsPrefix);
        return nsPrefix;
    }
}

