/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.xmleditor.completion;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.stp.sca.common.utils.DomUtils;
import org.eclipse.stp.sca.xmleditor.ImageRegistry;
import org.eclipse.stp.sca.xmleditor.Messages;
import org.eclipse.stp.sca.xmleditor.completion.AbstractProcessor;
import org.eclipse.stp.sca.xmleditor.preferences.ScaXmlPreferenceUtils;
import org.eclipse.stp.sca.xmleditor.preferences.beans.ScaXmlAttribute;
import org.eclipse.stp.sca.xmleditor.preferences.beans.ScaXmlElement;
import org.eclipse.stp.sca.xmleditor.preferences.beans.ScaXmlNamespace;
import org.eclipse.stp.sca.xmleditor.preferences.beans.ScaXmlPlatform;
import org.eclipse.swt.graphics.Image;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScaPreferenceProcessor
extends AbstractProcessor {
    private static /* synthetic */ int[] $SWITCH_TABLE$org$eclipse$stp$sca$xmleditor$completion$AbstractProcessor$Location;

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return new IContextInformation[0];
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return new char[]{'.'};
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return new char[0];
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    @Override
    protected ICompletionProposal[] computeCompletionProposals(AbstractProcessor.Location location) {
        ArrayList<CompletionProposal> proposals = new ArrayList<CompletionProposal>();
        switch (location) {
            case inElement: {
                boolean rightAfterOpeningMarkup = this.markupName.length() == 0;
                Map<ScaXmlElement, String> elementProposals = this.getElementProposals(rightAfterOpeningMarkup);
                String nodeName = this.element.getNodeName();
                int replacedLength = rightAfterOpeningMarkup ? 0 : nodeName.length();
                Image image = ImageRegistry.getInstance().markupProposalImg;
                for (Map.Entry<ScaXmlElement, String> entry : elementProposals.entrySet()) {
                    String proposalText;
                    String prefix = entry.getValue();
                    if (prefix.length() > 0) {
                        prefix = String.valueOf(prefix) + ":";
                    }
                    if (rightAfterOpeningMarkup || this.element.getAttributes().getLength() == 0) {
                        proposalText = this.createElementProposalText(entry.getKey(), prefix);
                        proposalText = proposalText.substring(1);
                    } else {
                        proposalText = String.valueOf(prefix) + entry.getKey().getName();
                    }
                    String explaination = "<b>" + Messages.ScaPreferenceProcessor_1 + "</b>" + entry.getKey().getName() + "<br><b>" + Messages.ScaPreferenceProcessor_2 + "</b>" + entry.getKey().getParentPlatform().getName();
                    proposals.add(new CompletionProposal(proposalText, this.offset - replacedLength, replacedLength, proposalText.length(), image, String.valueOf(prefix) + entry.getKey().getName(), null, explaination));
                }
                break;
            }
            case afterElement: {
                Map<ScaXmlElement, String> elementProposals2 = this.getElementProposals(true);
                Image image2 = ImageRegistry.getInstance().activeMarkupProposalImg;
                for (Map.Entry<ScaXmlElement, String> entry : elementProposals2.entrySet()) {
                    String prefix = entry.getValue();
                    if (prefix.length() > 0) {
                        prefix = String.valueOf(prefix) + ":";
                    }
                    String proposalText = this.createElementProposalText(entry.getKey(), prefix);
                    String explaination = "<b>" + Messages.ScaPreferenceProcessor_1 + "</b>" + entry.getKey().getName() + "<br><b>" + Messages.ScaPreferenceProcessor_2 + "</b>" + entry.getKey().getParentPlatform().getName();
                    proposals.add(new CompletionProposal(proposalText, this.offset, 0, proposalText.length(), image2, String.valueOf(prefix) + entry.getKey().getName(), null, explaination));
                }
                break;
            }
            case inAttributeName: {
                Map<ScaXmlElement, String> elementProposals3 = this.getElementProposals(false);
                Map<ScaXmlAttribute, String> attributeProposals = this.getAttributeProposals(elementProposals3, this.attributeName);
                Image image3 = ImageRegistry.getInstance().attributeImg;
                for (Map.Entry<ScaXmlAttribute, String> entry : attributeProposals.entrySet()) {
                    String explaination = "<b>" + Messages.ScaPreferenceProcessor_1 + "</b>" + entry.getKey().getElement().getName() + "<br><b>" + Messages.ScaPreferenceProcessor_2 + "</b>" + entry.getKey().getElement().getParentPlatform().getName();
                    proposals.add(new CompletionProposal(entry.getValue(), this.offset - this.attributeName.length(), this.attributeName.length(), entry.getValue().length(), image3, entry.getKey().getName(), null, explaination));
                }
                break;
            }
            case inAttributeValue: {
                if (!this.attributeName.startsWith("xmlns")) break;
                StringBuffer buf = new StringBuffer();
                int j = 0;
                while (j < this.textAfterOffset.length()) {
                    char c = this.textAfterOffset.charAt(j);
                    if (c == '\'' || c == '\"' || c == '>' || c == '\n' || c == '\r') break;
                    buf.append(c);
                    ++j;
                }
                String s = buf.toString();
                int replacementLength = this.attributeValue.length() + (s == null ? 0 : s.length());
                for (ScaXmlNamespace namespace : ScaXmlPreferenceUtils.getAllNamespaces()) {
                    String explaination = "<b>" + Messages.ScaPreferenceProcessor_3 + "</b>" + namespace.getName() + "<br><b>" + Messages.ScaPreferenceProcessor_2 + "</b>" + namespace.getPlatform().getName();
                    proposals.add(new CompletionProposal(namespace.getName(), this.offset - this.attributeValue.length(), replacementLength, namespace.getName().length(), null, namespace.getName(), null, explaination));
                }
                break;
            }
        }
        ICompletionProposal[] result = new ICompletionProposal[proposals.size()];
        return proposals.toArray(result);
    }

    private Map<ScaXmlElement, String> getElementProposals(boolean addNull) {
        List<Node> hierarchy = this.getReversedNodeHierarchyForPreferences(this.element);
        if (hierarchy.size() == 0) {
            return Collections.emptyMap();
        }
        if (addNull && hierarchy.size() > 1) {
            hierarchy.add(null);
        }
        Map<ScaXmlElement, String> result = this.findMatchingElements(hierarchy.get(0), null);
        Collection<ScaXmlElement> possibleElements = result.keySet();
        int i = 1;
        while (i < hierarchy.size()) {
            Node node = hierarchy.get(i);
            result = this.findMatchingElements(node, possibleElements);
            possibleElements = new ArrayList();
            for (ScaXmlElement elt : result.keySet()) {
                possibleElements.addAll(elt.children);
            }
            ++i;
        }
        return result;
    }

    private Map<ScaXmlAttribute, String> getAttributeProposals(Map<ScaXmlElement, String> elementProposals, String attributeName) {
        ArrayList<String> attrNames = new ArrayList<String>();
        int i = 0;
        while (i < this.element.getAttributes().getLength()) {
            Node attrNode = this.element.getAttributes().item(i);
            String name = attrNode.getLocalName() == null ? attrNode.getNodeName() : attrNode.getLocalName();
            attrNames.add(name);
            ++i;
        }
        HashMap<ScaXmlAttribute, String> result = new HashMap<ScaXmlAttribute, String>();
        for (ScaXmlElement elt : elementProposals.keySet()) {
            for (ScaXmlAttribute attribute : elt.attributes) {
                if (!attribute.getName().startsWith(attributeName) || attrNames.contains(attribute.getName())) continue;
                result.put(attribute, this.createAttributeProposalText(attribute));
            }
        }
        return result;
    }

    private String createAttributeProposalText(ScaXmlAttribute attribute) {
        String result = String.valueOf(attribute.getName()) + "=\"";
        result = attribute.getUse() == ScaXmlAttribute.ScaXmlAttributeProperty.fixed ? String.valueOf(result) + attribute.getFixedValue() : String.valueOf(result) + attribute.getDefaultValue();
        result = String.valueOf(result) + "\"";
        return result;
    }

    private String createElementProposalText(ScaXmlElement element, String prefix) {
        StringBuffer buf = new StringBuffer("<" + prefix + element.getName());
        for (ScaXmlAttribute attr : element.attributes) {
            if (attr.getUse() == ScaXmlAttribute.ScaXmlAttributeProperty.required) {
                buf.append(" " + attr.getName() + "=\"" + attr.getDefaultValue() + "\"");
                continue;
            }
            if (attr.getUse() != ScaXmlAttribute.ScaXmlAttributeProperty.fixed) continue;
            buf.append(" " + attr.getName() + "=\"" + attr.getFixedValue() + "\"");
        }
        if (element.children.size() > 0) {
            buf.append("></" + prefix + element.getName() + ">");
        } else {
            buf.append(" />");
        }
        return buf.toString();
    }

    private List<Node> getReversedNodeHierarchyForPreferences(Node currentNode) {
        ArrayList<Node> hierarchy = new ArrayList<Node>();
        boolean removeComponent = false;
        Node node = currentNode;
        while (node != null) {
            hierarchy.add(node);
            if (node.getNodeName().endsWith(":service") || node.getNodeName().equals("service") || node.getNodeName().endsWith(":reference") || node.getNodeName().equals("reference")) {
                removeComponent = true;
            }
            node = "component".equalsIgnoreCase(node.getLocalName()) || node.getNodeName().endsWith(":component") ? null : node.getParentNode();
        }
        Collections.reverse(hierarchy);
        node = (Node)hierarchy.get(0);
        if (!"component".equalsIgnoreCase(node.getLocalName()) && !node.getNodeName().endsWith(":component")) {
            return Collections.emptyList();
        }
        if (removeComponent) {
            hierarchy.remove(0);
        }
        return hierarchy;
    }

    private Map<ScaXmlElement, String> findMatchingElements(Node currentNode, Collection<ScaXmlElement> possibleMatchingElements) {
        HashMap<ScaXmlElement, String> result = new HashMap<ScaXmlElement, String>();
        HashMap<Object, String> nsAndPrefix = new HashMap<Object, String>();
        Node node = currentNode == null ? this.element : currentNode;
        for (String nsUri : DomUtils.getNamespaceMappings((Node)node).values()) {
            String prefix = DomUtils.lookupNamespacePrefix((String)nsUri, (Node)node);
            if (prefix == null) continue;
            nsAndPrefix.put(prefix, nsUri);
        }
        if (possibleMatchingElements == null) {
            HashSet<ScaXmlPlatform> matchingPlatforms = new HashSet<ScaXmlPlatform>();
            block1: for (ScaXmlPlatform platform : ScaXmlPreferenceUtils.getPlatformsFromPS()) {
                for (String ns : nsAndPrefix.values()) {
                    if (!platform.namespaces.contains(new ScaXmlNamespace(ns, null))) continue;
                    matchingPlatforms.add(platform);
                    continue block1;
                }
            }
            ArrayList<ScaXmlElement> matchingElements = new ArrayList<ScaXmlElement>();
            if (node.getNodeName().endsWith(":service") || node.getNodeName().equals("service") || node.getNodeName().endsWith(":reference") || node.getNodeName().equals("reference")) {
                for (ScaXmlPlatform platform : matchingPlatforms) {
                    matchingElements.addAll(platform.bindings);
                    matchingElements.addAll(platform.interfaces);
                }
            } else if (node.getNodeName().endsWith(":component") || node.getNodeName().equals("component")) {
                for (ScaXmlPlatform platform : matchingPlatforms) {
                    matchingElements.addAll(platform.implementations);
                }
            }
            for (ScaXmlElement elt : matchingElements) {
                for (Map.Entry entry : nsAndPrefix.entrySet()) {
                    if (!elt.hasNamespace((String)entry.getValue())) continue;
                    result.put(elt, (String)entry.getKey());
                }
            }
        } else if (currentNode == null) {
            for (ScaXmlElement elt : possibleMatchingElements) {
                for (Map.Entry entry : nsAndPrefix.entrySet()) {
                    if (!elt.hasNamespace((String)entry.getValue())) continue;
                    result.put(elt, (String)entry.getKey());
                }
            }
        } else {
            for (ScaXmlElement elt : possibleMatchingElements) {
                for (Map.Entry entry : nsAndPrefix.entrySet()) {
                    if (!elt.hasNamespace((String)entry.getValue())) continue;
                    String filter = ((String)entry.getKey()).length() == 0 ? "" : String.valueOf((String)entry.getKey()) + ":";
                    if (!(filter = String.valueOf(filter) + elt.getName()).startsWith(currentNode.getNodeName())) continue;
                    result.put(elt, (String)entry.getKey());
                }
            }
        }
        return result;
    }
}

