/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.xmleditor.outline;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.stp.sca.common.utils.DomUtils;
import org.eclipse.stp.sca.xmleditor.Messages;
import org.eclipse.stp.sca.xmleditor.outline.NodeActions;
import org.eclipse.stp.sca.xmleditor.outline.ScaXmlContentProvider;
import org.eclipse.stp.sca.xmleditor.outline.ScaXmlLabelProvider;
import org.eclipse.stp.sca.xmleditor.outline.ScaXmlMouseMoveListener;
import org.eclipse.stp.sca.xmleditor.statusline.StatusLineLabelProvider;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.wst.sse.ui.views.contentoutline.ContentOutlineConfiguration;
import org.w3c.dom.Node;

public class ScaXmlOutlineConfiguration
extends ContentOutlineConfiguration {
    private IContentProvider contentProvider;
    private ILabelProvider labelProvider;
    private ILabelProvider statusLineLabelProvider;
    private IMenuListener nodeMenuListener;
    private static final ImageDescriptor EXPAND_ALL_E = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.stp.sca.xmleditors", (String)"icons/full/elcl16/expandall.gif");
    private static final ImageDescriptor COLLAPSE_ALL_E = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.stp.sca.xmleditors", (String)"icons/full/elcl16/collapseall.gif");
    private static final ImageDescriptor COLLAPSE_ALL_D = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.stp.sca.xmleditors", (String)"icons/full/dlcl16/collapseall.gif");

    public IContentProvider getContentProvider(TreeViewer viewer) {
        if (this.contentProvider == null) {
            this.contentProvider = new ScaXmlContentProvider();
            new ScaXmlMouseMoveListener(viewer);
        }
        return this.contentProvider;
    }

    public ILabelProvider getLabelProvider(TreeViewer viewer) {
        if (this.labelProvider == null) {
            this.labelProvider = new ScaXmlLabelProvider();
        }
        return this.labelProvider;
    }

    public ILabelProvider getStatusLineLabelProvider(TreeViewer treeViewer) {
        if (this.statusLineLabelProvider == null) {
            this.statusLineLabelProvider = new StatusLineLabelProvider();
        }
        return this.statusLineLabelProvider;
    }

    protected IContributionItem[] createToolbarContributions(TreeViewer viewer) {
        viewer.setComparator((ViewerComparator)new NodeComparator());
        ActionContributionItem collapseAllItem = new ActionContributionItem((IAction)new CollapseTreeAction(viewer));
        ActionContributionItem expandAllItem = new ActionContributionItem((IAction)new ExpandTreeAction(viewer));
        IContributionItem[] items = new IContributionItem[]{collapseAllItem, expandAllItem};
        return items;
    }

    public IMenuListener getMenuListener(TreeViewer viewer) {
        if (this.nodeMenuListener == null) {
            this.nodeMenuListener = new NodeMenuListener(viewer);
        }
        return this.nodeMenuListener;
    }

    static /* synthetic */ ImageDescriptor access$0() {
        return EXPAND_ALL_E;
    }

    static /* synthetic */ ImageDescriptor access$1() {
        return COLLAPSE_ALL_E;
    }

    static /* synthetic */ ImageDescriptor access$2() {
        return COLLAPSE_ALL_D;
    }

    private class CollapseTreeAction
    extends Action {
        private final TreeViewer fTreeViewer;

        public CollapseTreeAction(TreeViewer viewer) {
            super(Messages.ScaCompositeContentOutlineConfiguration_5, COLLAPSE_ALL_E);
            this.setDisabledImageDescriptor(COLLAPSE_ALL_D);
            this.setToolTipText(Messages.ScaCompositeContentOutlineConfiguration_6);
            this.fTreeViewer = viewer;
        }

        public void run() {
            super.run();
            this.fTreeViewer.collapseAll();
        }
    }

    private class ExpandTreeAction
    extends Action {
        private final TreeViewer fTreeViewer;

        public ExpandTreeAction(TreeViewer viewer) {
            super(Messages.ScaCompositeContentOutlineConfiguration_3, EXPAND_ALL_E);
            this.setToolTipText(Messages.ScaCompositeContentOutlineConfiguration_4);
            this.fTreeViewer = viewer;
        }

        public void run() {
            super.run();
            this.fTreeViewer.expandAll();
        }
    }

    private class NodeComparator
    extends ViewerComparator {
        static final int DEFAULT_CATEGORY = 0;
        static final int COMPONENT_CATEGORY = 1;
        static final int SERVICE_CATEGORY = 2;
        static final int REFERENCE_CATEGORY = 3;
        static final int WIRE_CATEGORY = 4;
        static final int PROPERTY_CATEGORY = 5;
        static final int INCLUDE_CATEGORY = 6;
        static final int IMPLEMENTATION_CATEGORY = 7;
        static final int BINDING_CATEGORY = 8;
        static final int INTERFACE_CATEGORY = 9;

        private NodeComparator() {
        }

        public int category(Object element) {
            if (element == null || !(element instanceof Node)) {
                return 0;
            }
            String nodeName = DomUtils.getNodeName((Node)((Node)element));
            if ((nodeName = nodeName.toLowerCase()).equals("component")) {
                return 1;
            }
            if (nodeName.equals("service")) {
                return 2;
            }
            if (nodeName.equals("reference")) {
                return 3;
            }
            if (nodeName.equals("wire")) {
                return 4;
            }
            if (nodeName.equals("property")) {
                return 5;
            }
            if (nodeName.equals("include")) {
                return 6;
            }
            if (nodeName.startsWith("implementation.")) {
                return 7;
            }
            if (nodeName.startsWith("interface.")) {
                return 9;
            }
            if (nodeName.startsWith("binding.")) {
                return 8;
            }
            return 0;
        }
    }

    private class NodeMenuListener
    implements IMenuListener {
        private final TreeViewer fTreeViewer;
        private final NodeActions actions = new NodeActions();

        public NodeMenuListener(TreeViewer viewer) {
            this.fTreeViewer = viewer;
        }

        public void menuAboutToShow(IMenuManager manager) {
            manager.setRemoveAllWhenShown(true);
            this.actions.fillInContextMenu(this.fTreeViewer, manager);
        }
    }
}

