/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.xmleditor.preferences;

import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.stp.sca.xmleditor.ScaXmlEditorsPlugin;
import org.eclipse.stp.sca.xmleditor.preferences.ScaXmlPreferenceUtils;
import org.eclipse.stp.sca.xmleditor.preferences.beans.ScaXmlAttribute;
import org.eclipse.stp.sca.xmleditor.preferences.beans.ScaXmlElement;
import org.eclipse.stp.sca.xmleditor.preferences.beans.ScaXmlNamespace;
import org.eclipse.stp.sca.xmleditor.preferences.beans.ScaXmlPlatform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScaXmlPreferenceInitializer
extends AbstractPreferenceInitializer {
    public void initializeDefaultPreferences() {
        List<ScaXmlPlatform> platforms = ScaXmlPreferenceInitializer.getDefaultPreferences();
        ScaXmlPreferenceUtils.savePlatformsToPS(platforms);
    }

    public static List<ScaXmlPlatform> getDefaultPreferences() {
        ArrayList<ScaXmlPlatform> platforms = new ArrayList<ScaXmlPlatform>();
        String[] propertySources = new String[]{"frascati.properties", "tuscany-1.0.properties", "fabric3.properties"};
        String[] scaElements = new String[]{"bindings", "implementations", "interfaces"};
        String[] stringArray = propertySources;
        int n = propertySources.length;
        int n2 = 0;
        while (n2 < n) {
            String propertySource = stringArray[n2];
            URL url = ScaXmlEditorsPlugin.getDefault().getBundle().getEntry("preferences/" + propertySource);
            try {
                Path path = new Path(FileLocator.toFileURL((URL)url).getPath());
                FileInputStream in = new FileInputStream(path.toFile());
                Properties properties = new Properties();
                properties.load(in);
                String name = properties.getProperty("name", null);
                if (name != null) {
                    ScaXmlPlatform platform = new ScaXmlPlatform(name);
                    HashMap<String, ScaXmlElement> elementIdToElement = new HashMap<String, ScaXmlElement>();
                    String[] stringArray2 = scaElements;
                    int n3 = scaElements.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String elementName = stringArray2[n4];
                        String elements = properties.getProperty(elementName, "");
                        String[] stringArray3 = elements.split(",");
                        int n5 = stringArray3.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            String elementId = stringArray3[n6];
                            ScaXmlElement elt = ScaXmlPreferenceInitializer.processElement(properties, elementId = elementId.trim(), platform);
                            if (elt != null) {
                                elementIdToElement.put(elementId, elt);
                                platform.registerElement(elt, ScaXmlPlatform.ScaXmlElementType.valueOf(elementName));
                            }
                            ++n6;
                        }
                        ++n4;
                    }
                    String namespaces = properties.getProperty("namespaces", "");
                    String[] stringArray4 = namespaces.split(",");
                    int n7 = stringArray4.length;
                    n3 = 0;
                    while (n3 < n7) {
                        String namespaceId = stringArray4[n3];
                        String nsUri = properties.getProperty(String.valueOf(namespaceId = namespaceId.trim()) + ".uri", null);
                        if (nsUri != null) {
                            ScaXmlNamespace ns = new ScaXmlNamespace(nsUri, platform);
                            platform.namespaces.add(ns);
                            String[] stringArray5 = scaElements;
                            int n8 = scaElements.length;
                            int n9 = 0;
                            while (n9 < n8) {
                                String elementName = stringArray5[n9];
                                String mapping = properties.getProperty(String.valueOf(namespaceId) + "." + elementName, "");
                                String[] stringArray6 = mapping.split(",");
                                int n10 = stringArray6.length;
                                int n11 = 0;
                                while (n11 < n10) {
                                    String elementId = stringArray6[n11];
                                    ScaXmlElement elt = (ScaXmlElement)elementIdToElement.get(elementId.trim());
                                    if (elt != null) {
                                        platform.registerMapping(ns, elt, ScaXmlPlatform.ScaXmlElementType.valueOf(elementName));
                                    }
                                    ++n11;
                                }
                                ++n9;
                            }
                        }
                        ++n3;
                    }
                    platforms.add(platform);
                }
            }
            catch (IOException e) {
                ScaXmlEditorsPlugin.log(null, e, 4);
            }
            ++n2;
        }
        return platforms;
    }

    private static ScaXmlElement processElement(Properties properties, String elementId, Object parent) {
        String name = properties.getProperty(String.valueOf(elementId) + ".name", null);
        if (name == null) {
            return null;
        }
        ScaXmlElement elt = parent instanceof ScaXmlElement ? new ScaXmlElement(name, (ScaXmlElement)parent) : new ScaXmlElement(name, (ScaXmlPlatform)parent);
        String attributes = properties.getProperty(String.valueOf(elementId) + ".attributes", "");
        String[] stringArray = attributes.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String attributeName;
            String attribute = stringArray[n2];
            attribute = attribute.trim();
            int index = attribute.lastIndexOf(61);
            String use = "optional";
            if (index > 0) {
                attributeName = attribute.substring(0, index).trim();
                use = attribute.substring(index).replace("=", "").trim().toLowerCase();
            } else {
                attributeName = attribute;
            }
            new ScaXmlAttribute(attributeName, elt, ScaXmlAttribute.ScaXmlAttributeProperty.valueOf(use));
            ++n2;
        }
        String subElements = properties.getProperty(String.valueOf(elementId) + ".elements", "");
        String[] stringArray2 = subElements.split(",");
        int n3 = stringArray2.length;
        n = 0;
        while (n < n3) {
            String subElementId = stringArray2[n];
            subElementId = subElementId.trim();
            ScaXmlPreferenceInitializer.processElement(properties, subElementId, elt);
            ++n;
        }
        return elt;
    }
}

