/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.xmleditor.preferences.beans;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.stp.sca.xmleditor.preferences.beans.ScaXmlElement;
import org.eclipse.stp.sca.xmleditor.preferences.beans.ScaXmlItem;
import org.eclipse.stp.sca.xmleditor.preferences.beans.ScaXmlNamespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScaXmlPlatform
extends ScaXmlItem
implements Externalizable {
    public final Set<ScaXmlNamespace> namespaces = new HashSet<ScaXmlNamespace>();
    public final Set<ScaXmlElement> bindings = new HashSet<ScaXmlElement>();
    public final Set<ScaXmlElement> implementations = new HashSet<ScaXmlElement>();
    public final Set<ScaXmlElement> interfaces = new HashSet<ScaXmlElement>();
    public final Map<ScaXmlNamespace, List<ScaXmlElement>> nsToBindings = new HashMap<ScaXmlNamespace, List<ScaXmlElement>>();
    public final Map<ScaXmlNamespace, List<ScaXmlElement>> nsToImplementations = new HashMap<ScaXmlNamespace, List<ScaXmlElement>>();
    public final Map<ScaXmlNamespace, List<ScaXmlElement>> nsToInterfaces = new HashMap<ScaXmlNamespace, List<ScaXmlElement>>();

    public ScaXmlPlatform() {
    }

    public ScaXmlPlatform(String name) {
        this.name = name;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        ArrayList<Integer> ids;
        ScaXmlNamespace ns;
        ScaXmlElement elt;
        this.name = in.readUTF();
        Set set = (Set)in.readObject();
        for (Object o : set) {
            ScaXmlNamespace ns2 = (ScaXmlNamespace)o;
            ns2.setPlatform(this);
            this.namespaces.add(ns2);
        }
        set = (Set)in.readObject();
        for (Object o : set) {
            elt = (ScaXmlElement)o;
            elt.setPlatform(this);
            this.bindings.add(elt);
        }
        set = (Set)in.readObject();
        for (Object o : set) {
            elt = (ScaXmlElement)o;
            elt.setPlatform(this);
            this.implementations.add(elt);
        }
        set = (Set)in.readObject();
        for (Object o : set) {
            elt = (ScaXmlElement)o;
            elt.setPlatform(this);
            this.interfaces.add(elt);
        }
        Map map = (Map)in.readObject();
        for (Map.Entry entry : map.entrySet()) {
            ns = (ScaXmlNamespace)entry.getKey();
            ids = new ArrayList<Integer>();
            for (Object id : (List)entry.getValue()) {
                ids.add((Integer)id);
            }
            this.nsToBindings.put(ns, this.getMappingToElements(ids, ScaXmlElementType.bindings));
        }
        map = (Map)in.readObject();
        for (Map.Entry entry : map.entrySet()) {
            ns = (ScaXmlNamespace)entry.getKey();
            ids = new ArrayList();
            for (Object id : (List)entry.getValue()) {
                ids.add((Integer)id);
            }
            this.nsToImplementations.put(ns, this.getMappingToElements(ids, ScaXmlElementType.implementations));
        }
        map = (Map)in.readObject();
        for (Map.Entry entry : map.entrySet()) {
            ns = (ScaXmlNamespace)entry.getKey();
            ids = new ArrayList();
            for (Object id : (List)entry.getValue()) {
                ids.add((Integer)id);
            }
            this.nsToInterfaces.put(ns, this.getMappingToElements(ids, ScaXmlElementType.interfaces));
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeObject(this.namespaces);
        out.writeObject(this.bindings);
        out.writeObject(this.implementations);
        out.writeObject(this.interfaces);
        Map<ScaXmlNamespace, List<Integer>> bindMapIds = this.getMappingToIds(this.nsToBindings);
        out.writeObject(bindMapIds);
        Map<ScaXmlNamespace, List<Integer>> implMapIds = this.getMappingToIds(this.nsToImplementations);
        out.writeObject(implMapIds);
        Map<ScaXmlNamespace, List<Integer>> interfMapIds = this.getMappingToIds(this.nsToInterfaces);
        out.writeObject(interfMapIds);
    }

    private Map<ScaXmlNamespace, List<Integer>> getMappingToIds(Map<ScaXmlNamespace, List<ScaXmlElement>> association) {
        HashMap<ScaXmlNamespace, List<Integer>> nsToElementIds = new HashMap<ScaXmlNamespace, List<Integer>>();
        for (Map.Entry<ScaXmlNamespace, List<ScaXmlElement>> entry : association.entrySet()) {
            ArrayList<Integer> ids = new ArrayList<Integer>();
            for (ScaXmlElement elt : entry.getValue()) {
                ids.add(elt.getId());
            }
            nsToElementIds.put(entry.getKey(), ids);
        }
        return nsToElementIds;
    }

    private List<ScaXmlElement> getMappingToElements(List<Integer> ids, ScaXmlElementType type) {
        Set<ScaXmlElement> elementSet = type == ScaXmlElementType.bindings ? this.bindings : (type == ScaXmlElementType.implementations ? this.implementations : this.interfaces);
        ArrayList<ScaXmlElement> elements = new ArrayList<ScaXmlElement>();
        for (Integer id : ids) {
            for (ScaXmlElement elt : elementSet) {
                if (id.intValue() != elt.getId()) continue;
                elements.add(elt);
            }
        }
        return elements;
    }

    public void remove(ScaXmlItem element) {
        this.bindings.remove(element);
        this.implementations.remove(element);
        this.interfaces.remove(element);
        for (List<ScaXmlElement> set : this.nsToBindings.values()) {
            set.remove(element);
        }
        for (List<ScaXmlElement> set : this.nsToImplementations.values()) {
            set.remove(element);
        }
        for (List<ScaXmlElement> set : this.nsToInterfaces.values()) {
            set.remove(element);
        }
    }

    public void registerMapping(ScaXmlNamespace namespace, ScaXmlElement element, ScaXmlElementType type) {
        Map<ScaXmlNamespace, List<ScaXmlElement>> map = type == ScaXmlElementType.bindings ? this.nsToBindings : (type == ScaXmlElementType.implementations ? this.nsToImplementations : this.nsToInterfaces);
        List<ScaXmlElement> elements = map.get(namespace);
        if (elements == null) {
            elements = new ArrayList<ScaXmlElement>();
        }
        elements.add(element);
        map.put(namespace, elements);
    }

    public void registerElement(ScaXmlElement element, ScaXmlElementType type) {
        Set<ScaXmlElement> elementSet = type == ScaXmlElementType.bindings ? this.bindings : (type == ScaXmlElementType.implementations ? this.implementations : this.interfaces);
        elementSet.add(element);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ScaXmlElementType {
        bindings,
        implementations,
        interfaces;

    }
}

