/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.xmleditor.preferences.dialogs;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.stp.sca.xmleditor.Messages;
import org.eclipse.stp.sca.xmleditor.preferences.beans.ScaXmlElement;
import org.eclipse.stp.sca.xmleditor.preferences.beans.ScaXmlNamespace;
import org.eclipse.stp.sca.xmleditor.preferences.beans.ScaXmlPlatform;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class RootElementEditionDialog
extends Dialog {
    private ScaXmlElement newElement;
    private final ScaXmlPlatform platform;
    private String prefix;
    private Text nameText;
    private Table namespacesTable;
    private Label errorLabel;
    private Map<ScaXmlNamespace, List<ScaXmlElement>> map;

    public RootElementEditionDialog(Shell parentShell, ScaXmlPlatform.ScaXmlElementType elementType, ScaXmlPlatform platform) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.platform = platform;
        this.prefix = elementType.toString();
        this.prefix = this.prefix.substring(0, this.prefix.length() - 1);
        this.map = elementType == ScaXmlPlatform.ScaXmlElementType.bindings ? platform.nsToBindings : (elementType == ScaXmlPlatform.ScaXmlElementType.implementations ? platform.nsToImplementations : platform.nsToInterfaces);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        String type = String.valueOf(this.prefix.toUpperCase().charAt(0)) + this.prefix.toLowerCase().substring(1);
        this.getShell().setText(NLS.bind((String)Messages.RootElementEditionDialog_0, (Object[])new Object[]{this.platform.getName(), type}));
        GridLayout layout = new GridLayout();
        layout.marginWidth = 20;
        layout.marginHeight = 20;
        layout.horizontalSpacing = 20;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(1808));
        new Label(container, 0).setText(Messages.RootElementEditionDialog_2);
        this.nameText = new Text(container, 2052);
        if (this.newElement != null && this.newElement.getName() != null) {
            this.nameText.setText(this.newElement.getName());
        } else {
            this.nameText.setText(NLS.bind((String)Messages.RootElementEditionDialog_3, (Object)this.prefix));
        }
        this.nameText.setLayoutData((Object)new GridData(768));
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RootElementEditionDialog.this.validate();
            }
        });
        Label l = new Label(container, 0);
        l.setText(Messages.RootElementEditionDialog_4);
        GridData layoutData = new GridData(2);
        layoutData.verticalIndent = 10;
        l.setLayoutData((Object)layoutData);
        this.namespacesTable = new Table(container, 100384);
        layoutData = new GridData(1808);
        layoutData.heightHint = 50;
        this.namespacesTable.setLayoutData((Object)layoutData);
        this.namespacesTable.setHeaderVisible(false);
        for (ScaXmlNamespace ns : this.platform.namespaces) {
            TableItem item = new TableItem(this.namespacesTable, 0);
            item.setText(ns.getName());
            item.setData((Object)ns);
            if (this.newElement == null || this.map.get(ns) == null || !this.map.get(ns).contains(this.newElement)) continue;
            item.setChecked(true);
        }
        this.namespacesTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RootElementEditionDialog.this.validate();
            }
        });
        layoutData = new GridData();
        layoutData.verticalIndent = 10;
        this.errorLabel = new Label(container, 0);
        this.errorLabel.setLayoutData((Object)layoutData);
        this.nameText.setFocus();
        this.nameText.setSelection(this.nameText.getText().length());
        return container;
    }

    protected void okPressed() {
        if (this.newElement != null) {
            this.newElement.setName(this.getElementName());
        } else {
            this.newElement = new ScaXmlElement(this.getElementName(), this.platform);
            if (this.map == this.platform.nsToBindings) {
                this.platform.bindings.add(this.newElement);
            } else if (this.map == this.platform.nsToImplementations) {
                this.platform.implementations.add(this.newElement);
            } else {
                this.platform.interfaces.add(this.newElement);
            }
        }
        for (List<ScaXmlElement> set : this.map.values()) {
            set.remove(this.newElement);
        }
        ArrayList<TableItem> checkedItems = new ArrayList<TableItem>();
        TableItem[] tableItemArray = this.namespacesTable.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (item.getChecked()) {
                checkedItems.add(item);
            }
            ++n2;
        }
        for (TableItem item : checkedItems) {
            ScaXmlNamespace ns = (ScaXmlNamespace)item.getData();
            List<ScaXmlElement> elements = this.map.get(ns);
            if (elements != null) {
                elements.add(this.newElement);
            } else {
                elements = new ArrayList<ScaXmlElement>();
                elements.add(this.newElement);
            }
            this.map.put(ns, elements);
        }
        super.okPressed();
    }

    private String getElementName() {
        if (!this.nameText.getText().startsWith(String.valueOf(this.prefix) + ".")) {
            return String.valueOf(this.prefix) + "." + this.nameText.getText();
        }
        return this.nameText.getText();
    }

    public ScaXmlElement getNewElement() {
        return this.newElement;
    }

    public void setNewElement(ScaXmlElement newElement) {
        this.newElement = newElement;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setEnabled(false);
    }

    protected Point getInitialSize() {
        return new Point(400, 300);
    }

    public void validate() {
        String name = this.nameText.getText();
        if (name.length() == 0 || !Character.isJavaIdentifierStart(name.charAt(0))) {
            this.updateStatus(Messages.RootElementEditionDialog_7);
            return;
        }
        ArrayList<TableItem> checkedItems = new ArrayList<TableItem>();
        TableItem[] tableItemArray = this.namespacesTable.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (item.getChecked()) {
                checkedItems.add(item);
            }
            ++n2;
        }
        if (checkedItems.size() == 0) {
            this.updateStatus(Messages.RootElementEditionDialog_8);
            return;
        }
        for (TableItem item : checkedItems) {
            ScaXmlNamespace ns = (ScaXmlNamespace)item.getData();
            List<ScaXmlElement> elements = this.map.get(ns);
            if (elements == null) continue;
            name = this.getElementName();
            for (ScaXmlElement elt : elements) {
                if (!elt.getName().equals(name) || this.newElement != null && elt.getId() == this.newElement.getId()) continue;
                this.updateStatus(NLS.bind((String)Messages.RootElementEditionDialog_9, (Object[])new Object[]{elt.getName(), ns.getName()}));
                return;
            }
        }
        this.updateStatus(null);
    }

    public void updateStatus(String msg) {
        if (msg != null) {
            this.errorLabel.setText(msg);
            this.errorLabel.getParent().layout();
            this.getButton(0).setEnabled(false);
        } else {
            this.errorLabel.setText("");
            this.errorLabel.getParent().layout();
            this.getButton(0).setEnabled(true);
        }
    }
}

