/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.xmleditor.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.stp.sca.common.internal.provisional.filters.ScaResourceFiltersEPManager;
import org.eclipse.stp.sca.common.utils.ResourceUtils;
import org.eclipse.stp.sca.xmleditor.utils.ScaUtils;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IncludesUtils {
    private final List<IProject> projects = new ArrayList<IProject>();

    protected IncludesUtils(IProject project) {
        this.projects.add(project);
        try {
            IProject[] iProjectArray = project.getReferencedProjects();
            int n = iProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProject ref = iProjectArray[n2];
                this.projects.add(ref);
                ++n2;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public static IncludesUtils createIncludesUtils(IProject project) {
        if (project != null) {
            return new IncludesUtils(project);
        }
        return null;
    }

    public QName getQName(IFile file) {
        String namespaceUri;
        String compositeName;
        block3: {
            Document document = this.getDOM(file);
            try {
                Node compositeNode = ScaUtils.getScaTopNode(document);
                compositeName = ScaUtils.getAttributeValue(compositeNode, "name");
                namespaceUri = ScaUtils.getAttributeValue(compositeNode, "targetNamespace");
                if (!"".equals(namespaceUri)) break block3;
                return null;
            }
            catch (Exception exception) {
                return null;
            }
        }
        return new QName(namespaceUri, compositeName);
    }

    public List<QName> getQNames(IFile[] files) {
        ArrayList<QName> result = new ArrayList<QName>();
        IFile[] iFileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            IFile file = iFileArray[n2];
            QName qName = this.getQName(file);
            if (qName != null) {
                result.add(qName);
            }
            ++n2;
        }
        return result;
    }

    public List<QName> getQNames(List<IFile> files) {
        IFile[] iFiles = new IFile[files.size()];
        return this.getQNames(files.toArray(iFiles));
    }

    public List<QName> getQNames() {
        ArrayList<IFile> iFiles = new ArrayList<IFile>();
        for (IProject project : this.projects) {
            Set binaryFolders = ScaResourceFiltersEPManager.getInstance().getBinaryFolders(project);
            List pIFiles = ResourceUtils.getFiles((String)"composite", (Collection)binaryFolders);
            iFiles.addAll(pIFiles);
        }
        return this.getQNames(iFiles);
    }

    public IFile getIFile(QName qName) {
        ArrayList files = new ArrayList();
        for (IProject project : this.projects) {
            Set binaryFolders = ScaResourceFiltersEPManager.getInstance().getBinaryFolders(project);
            List pIFiles = ResourceUtils.getFiles((String)"composite", (Collection)binaryFolders);
            files.addAll(pIFiles);
        }
        for (IFile file : files) {
            QName fileQName = this.getQName(file);
            try {
                if (fileQName == null || !qName.equals(fileQName)) continue;
                return file;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public List<IFile> getIFiles(QName[] qNames) {
        ArrayList<IFile> result = new ArrayList<IFile>();
        QName[] qNameArray = qNames;
        int n = qNames.length;
        int n2 = 0;
        while (n2 < n) {
            QName name = qNameArray[n2];
            IFile file = this.getIFile(name);
            if (file != null) {
                result.add(file);
            }
            ++n2;
        }
        return result;
    }

    public List<IFile> getIFiles(List<QName> qNames) {
        QName[] names = new QName[qNames.size()];
        return this.getIFiles(qNames.toArray(names));
    }

    public List<IFile> getIFiles() {
        ArrayList<IFile> iFiles = new ArrayList<IFile>();
        for (IProject project : this.projects) {
            Set binaryFolders = ScaResourceFiltersEPManager.getInstance().getBinaryFolders(project);
            List pIFiles = ResourceUtils.getFiles((String)"composite", (Collection)binaryFolders);
            iFiles.addAll(pIFiles);
        }
        return iFiles;
    }

    public Document getDOM(IFile file) {
        try {
            IStructuredModel model = StructuredModelManager.getModelManager().getExistingModelForRead(file);
            return ((IDOMModel)model).getDocument();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<Document> getDOMs(IFile[] files) {
        ArrayList<Document> result = new ArrayList<Document>();
        IFile[] iFileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            IFile file = iFileArray[n2];
            Document document = this.getDOM(file);
            if (document != null) {
                result.add(document);
            }
            ++n2;
        }
        return result;
    }

    public List<Document> getDOMs(List<IFile> files) {
        IFile[] iFiles = new IFile[files.size()];
        return this.getDOMs(files.toArray(iFiles));
    }

    public List<Document> getDOMs() {
        ArrayList<IFile> iFiles = new ArrayList<IFile>();
        for (IProject project : this.projects) {
            Set binaryFolders = ScaResourceFiltersEPManager.getInstance().getBinaryFolders(project);
            List pIFiles = ResourceUtils.getFiles((String)"composite", (Collection)binaryFolders);
            iFiles.addAll(pIFiles);
        }
        return this.getDOMs(iFiles);
    }

    public Document getDOMbyQName(QName name) {
        IFile file = this.getIFile(name);
        if (file != null) {
            return this.getDOM(file);
        }
        return null;
    }

    public List<Document> getDOMsByQName(QName[] names) {
        ArrayList<Document> result = new ArrayList<Document>();
        QName[] qNameArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            QName name = qNameArray[n2];
            Document document = this.getDOMbyQName(name);
            if (document != null) {
                result.add(document);
            }
            ++n2;
        }
        return result;
    }

    public List<Document> getDOMsByQName(List<QName> names) {
        QName[] qNames = new QName[names.size()];
        return this.getDOMsByQName(names.toArray(qNames));
    }

    public static IFile getIncludedFile(Object node, IProject project) {
        if (!ScaUtils.isIncludeNode(node)) {
            return null;
        }
        QName qName = ScaUtils.getIncludeQName((Node)node);
        if (qName == null) {
            return null;
        }
        IncludesUtils includesUtils = new IncludesUtils(project);
        return includesUtils.getIFile(qName);
    }
}

