/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.ui.xef.schema;

import java.util.EnumSet;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.xs.XSAnnotation;
import org.eclipse.stp.ui.xef.schema.AnnotatedElement;
import org.eclipse.stp.ui.xef.schema.WidgetStyle;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAnnotatedElement
implements AnnotatedElement {
    String displayName;
    String docShort;
    String documentation;
    String category;
    Set<WidgetStyle> widgetStyles = EnumSet.noneOf(WidgetStyle.class);

    Document handleAnnotations(XSAnnotation annotation) {
        NodeList docShortNodes;
        String ds;
        NodeList displayNameNodes;
        String dn;
        if (annotation == null) {
            return null;
        }
        String doc = AbstractAnnotatedElement.getDocumentation(annotation);
        if (doc != null) {
            this.documentation = doc;
        }
        DocumentImpl domDoc = new DocumentImpl();
        annotation.writeAnnotation((Object)domDoc, (short)3);
        NodeList catNodes = domDoc.getElementsByTagNameNS("http://schemas.eclipse.org/stp/xsd/2006/05/xef", "category");
        String cat = AbstractAnnotatedElement.getTextValue(catNodes);
        if (cat != null) {
            this.category = cat;
        }
        if ((dn = AbstractAnnotatedElement.getI18nTextValue(displayNameNodes = domDoc.getElementsByTagNameNS("http://schemas.eclipse.org/stp/xsd/2006/05/xef", "displayName"))) != null) {
            this.displayName = dn;
        }
        if ((ds = AbstractAnnotatedElement.getI18nTextValue(docShortNodes = domDoc.getElementsByTagNameNS("http://schemas.eclipse.org/stp/xsd/2006/05/xef", "docShort"))) != null) {
            this.docShort = ds;
        }
        NodeList widgetStyleNodes = domDoc.getElementsByTagNameNS("http://schemas.eclipse.org/stp/xsd/2006/05/xef/gui", "widget");
        this.widgetStyles = EnumSet.noneOf(WidgetStyle.class);
        int i = 0;
        while (i < widgetStyleNodes.getLength()) {
            Node n = widgetStyleNodes.item(i);
            String widgetType = AbstractAnnotatedElement.getTextValue(n);
            if (widgetType != null) {
                try {
                    this.widgetStyles.add(WidgetStyle.valueOf(widgetType.toUpperCase()));
                }
                catch (Throwable th) {
                    th.printStackTrace();
                }
            }
            ++i;
        }
        return domDoc;
    }

    static String getDocumentation(XSAnnotation annotation) {
        if (annotation == null) {
            return null;
        }
        String annotationText = annotation.getAnnotationString();
        if (annotationText == null) {
            return null;
        }
        String docString = AbstractAnnotatedElement.getLanguageDocumentation(annotationText, Locale.getDefault().getISO3Language());
        if (docString == null) {
            docString = AbstractAnnotatedElement.getLanguageDocumentation(annotationText, Locale.getDefault().getLanguage());
        }
        if (docString == null) {
            docString = AbstractAnnotatedElement.getDefaultDocumentation(annotationText);
        }
        return docString;
    }

    static String getDefaultDocumentation(String annotationText) {
        String x = ".*<([a-z]+[:])?documentation\\s*>(.*?)</([a-z]+[:])?documentation\\s*>.*";
        return AbstractAnnotatedElement.getPatternMatch(annotationText, x, 2);
    }

    static String getLanguageDocumentation(String annotationText, String langCode) {
        String x = ".*<([a-z]+[:])?documentation\\s+xml:lang\\s*=\\s*[\"']" + langCode + "[\"']\\s*>(.*?)</([a-z]+[:])?documentation\\s*>.*";
        return AbstractAnnotatedElement.getPatternMatch(annotationText, x, 2);
    }

    static String getPatternMatch(String text, String pattern, int refNr) {
        Pattern p = Pattern.compile(pattern, 32);
        Matcher m = p.matcher(text);
        if (m.matches()) {
            return m.replaceFirst("$" + refNr);
        }
        return null;
    }

    static String getAttributeValue(Node node, String ns_uri, String attr) {
        Node attrNode = node.getAttributes().getNamedItemNS(ns_uri, attr);
        if (attrNode != null) {
            return attrNode.getTextContent();
        }
        return null;
    }

    static String getTextValue(NodeList nodes) {
        if (nodes.getLength() > 0) {
            return AbstractAnnotatedElement.getTextValue(nodes.item(0));
        }
        return null;
    }

    static String getTextValue(Node node) {
        Node cur = node.getFirstChild();
        while (cur != null) {
            String text;
            if (cur.getNodeType() == 3 && !"".equals(text = cur.getTextContent().trim())) {
                return text;
            }
            cur = cur.getNextSibling();
        }
        return null;
    }

    static String getI18nTextValue(NodeList nodes) {
        Node node = AbstractAnnotatedElement.getI18nNode(nodes, Locale.getDefault().getISO3Language());
        if (node == null) {
            node = AbstractAnnotatedElement.getI18nNode(nodes, Locale.getDefault().getLanguage());
        }
        if (node == null) {
            node = AbstractAnnotatedElement.getI18nNode(nodes, null);
        }
        if (node == null) {
            return null;
        }
        return AbstractAnnotatedElement.getTextValue(node);
    }

    static Node getI18nNode(NodeList nodes, String language) {
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            String lang = AbstractAnnotatedElement.getAttributeValue(node, "http://www.w3.org/XML/1998/namespace", "lang");
            if (language == null && lang == null) {
                return node;
            }
            if (language != null && language.equalsIgnoreCase(lang)) {
                return node;
            }
            ++i;
        }
        return null;
    }

    @Override
    public String getCategory() {
        return this.category;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getDocShort() {
        return this.docShort;
    }

    @Override
    public String getDocumentation() {
        return this.documentation;
    }

    public Set<WidgetStyle> getWidgetStyles() {
        return this.widgetStyles;
    }
}

