/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swordfish.internal.core.configuration;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swordfish.core.configuration.ConfigurationConsumer;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.springframework.util.Assert;

public class ManagedServiceAdapter
implements ManagedService {
    private static final Log LOG = LogFactory.getLog(ManagedServiceAdapter.class);
    private ConfigurationConsumer delegate;

    public ManagedServiceAdapter() {
    }

    public ManagedServiceAdapter(ConfigurationConsumer configurationConsumer) {
        this.delegate = configurationConsumer;
    }

    public void updated(Dictionary properties) throws ConfigurationException {
        Assert.notNull((Object)this.delegate, (String)"The ConfigurationConsumer delegate must be supplied");
        if (properties == null) {
            this.delegate.onReceiveConfiguration(null);
            return;
        }
        HashMap configuration = new HashMap();
        Enumeration e = properties.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            configuration.put(key, properties.get(key));
        }
        LOG.info((Object)String.format("Received configuration [%s] for the configurationConsumer with id = [%s] ", ((Object)configuration).toString(), this.delegate.getId()));
        this.delegate.onReceiveConfiguration(configuration);
    }

    public ConfigurationConsumer getDelegate() {
        return this.delegate;
    }

    public void setDelegate(ConfigurationConsumer delegate) {
        this.delegate = delegate;
    }
}

