/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swordfish.internal.core.configuration.xml;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.XMLEvent;
import org.eclipse.swordfish.core.SwordfishException;
import org.eclipse.swordfish.internal.core.configuration.xml.XmlToPropertiesTransformer;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlToPropertiesTransformerImpl
implements XmlToPropertiesTransformer {
    private Map<String, String> properties;

    @Override
    public Map<String, String> getProperties() {
        Assert.notNull(this.properties);
        return this.properties;
    }

    @Override
    public boolean isConfigurationLoaded() {
        return this.properties != null;
    }

    @Override
    public Map<String, Map<String, String>> getPropertiesForPids() {
        Assert.state((this.properties != null ? 1 : 0) != 0, (String)"Configuration is not loaded");
        Set<String> prefixes = this.getPidPrefixes(this.properties.keySet());
        HashMap<String, Map<String, String>> ret = new HashMap<String, Map<String, String>>();
        for (String prefix : prefixes) {
            HashMap<String, String> pidProps = new HashMap<String, String>();
            for (String key : this.getKeysForPid(this.properties.keySet(), prefix)) {
                pidProps.put(key.substring(prefix.length() + 1), this.properties.get(key));
            }
            ret.put(prefix, pidProps);
        }
        return ret;
    }

    @Override
    public void loadConfiguration(String path) {
        Assert.notNull((Object)path);
        try {
            this.loadConfiguration(new URL(path));
        }
        catch (MalformedURLException ex) {
            throw new SwordfishException((Throwable)ex);
        }
    }

    @Override
    public void loadConfiguration(URL path) {
        Assert.notNull((Object)path);
        InputStream inputStream = null;
        try {
            try {
                inputStream = path.openStream();
                XMLInputFactory inputFactory = XMLInputFactory.newInstance();
                LinkedList<String> currentElements = new LinkedList<String>();
                XMLEventReader eventReader = inputFactory.createXMLEventReader(inputStream);
                HashMap<String, List<String>> props = new HashMap<String, List<String>>();
                while (eventReader.hasNext()) {
                    XMLEvent event = eventReader.nextEvent();
                    if (event.isCharacters() && !event.asCharacters().isWhiteSpace()) {
                        this.putElement(props, this.getQualifiedName(currentElements), event.asCharacters().getData());
                        continue;
                    }
                    if (event.isStartElement()) {
                        currentElements.add(event.asStartElement().getName().getLocalPart());
                        Iterator<Attribute> attrIt = event.asStartElement().getAttributes();
                        while (attrIt.hasNext()) {
                            Attribute attribute = attrIt.next();
                            this.putElement(props, String.valueOf(this.getQualifiedName(currentElements)) + "[@" + attribute.getName() + "]", attribute.getValue());
                        }
                        continue;
                    }
                    if (event.isAttribute() || !event.isEndElement()) continue;
                    String lastElem = event.asEndElement().getName().getLocalPart();
                    if (!currentElements.getLast().equals(lastElem)) {
                        throw new UnsupportedOperationException(String.valueOf(lastElem) + "," + currentElements.getLast());
                    }
                    currentElements.removeLast();
                }
                this.properties = this.flattenProperties(props);
            }
            catch (Exception ex) {
                throw new SwordfishException((Throwable)ex);
            }
        }
        catch (Throwable throwable) {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    private String getQualifiedName(List<String> elements) {
        if (elements.size() == 0) {
            return null;
        }
        StringBuilder ret = new StringBuilder(elements.get(0));
        int i = 1;
        while (i < elements.size()) {
            ret.append(".").append(elements.get(i));
            ++i;
        }
        return ret.toString();
    }

    private Map<String, String> flattenProperties(Map<String, List<String>> props) {
        HashMap<String, String> ret = new HashMap<String, String>(props.size());
        for (String key : props.keySet()) {
            List<String> values = props.get(key);
            Assert.state((values.size() > 0 ? 1 : 0) != 0);
            if (key.contains(".")) {
                key = key.substring(key.indexOf(".") + 1);
            }
            if (values.size() == 1) {
                ret.put(key, values.get(0));
                continue;
            }
            int i = 0;
            while (i < values.size()) {
                ret.put(String.valueOf(key) + "{" + (i + 1) + "}", values.get(i));
                ++i;
            }
        }
        return ret;
    }

    private void putElement(Map<String, List<String>> props, String key, String value) {
        if (props.containsKey(key)) {
            props.get(key).add(value);
        } else {
            LinkedList<String> list = new LinkedList<String>();
            list.add(value);
            props.put(key, list);
        }
    }

    private Set<String> getPidPrefixes(Set<String> keys) {
        HashSet<String> ret = new HashSet<String>();
        for (String key : keys) {
            String prefix = null;
            if (key.contains(".")) {
                prefix = key.substring(0, key.indexOf("."));
            }
            if (prefix == null) continue;
            ret.add(prefix);
        }
        return ret;
    }

    private Set<String> getKeysForPid(Set<String> keys, String prefix) {
        HashSet<String> ret = new HashSet<String>();
        for (String key : keys) {
            if (!key.startsWith(prefix)) continue;
            ret.add(key);
        }
        return ret;
    }
}

