/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swordfish.internal.core.planner;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jbi.messaging.MessageExchange;
import javax.xml.namespace.QName;
import org.eclipse.swordfish.core.Interceptor;
import org.eclipse.swordfish.core.planner.strategy.SortingStrategy;
import org.eclipse.swordfish.core.util.ReadOnlyRegistry;
import org.eclipse.swordfish.internal.core.util.smx.ExchangeRole;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoreSortingStrategy
implements SortingStrategy {
    public static final String PRIORITY_KEYWORD = "priority";

    private int getInterceptorPriority(Interceptor interceptor, ReadOnlyRegistry<Interceptor> registry, MessageExchange messageExchange) {
        ExchangeRole exchangeRole;
        QName qname;
        Map props = registry.getProperties((Object)interceptor);
        Integer priority = 0;
        if (props != null && props.containsKey(PRIORITY_KEYWORD)) {
            Object priorityProperty = props.get(PRIORITY_KEYWORD);
            if (priorityProperty instanceof Integer) {
                priority = priority + (Integer)priorityProperty;
            } else if (priorityProperty instanceof String) {
                priority = priority + Integer.valueOf((String)priorityProperty);
            } else {
                throw new UnsupportedOperationException(priorityProperty.getClass() + " could not be transformed to integer");
            }
        }
        if (props != null && props.containsKey("type") && props.get("type") instanceof QName && (qname = (QName)props.get("type")).getNamespaceURI().equalsIgnoreCase("http://interceptor.core.internal.swordfish.eclipse.org/") && ((exchangeRole = ExchangeRole.valueOf((MessageExchange)messageExchange)) == ExchangeRole.ConsumerRequest || exchangeRole == ExchangeRole.ProviderResponse)) {
            priority = priority + 0x3FFFFFFF;
        }
        return priority;
    }

    @Override
    public List<Interceptor> sort(Set<Interceptor> interceptors, final ReadOnlyRegistry<Interceptor> registry, final MessageExchange messageExchange) {
        ArrayList<Interceptor> sorted = new ArrayList<Interceptor>(interceptors);
        Collections.sort(sorted, new Comparator<Interceptor>(){

            @Override
            public int compare(Interceptor o1, Interceptor o2) {
                return CoreSortingStrategy.this.getInterceptorPriority(o2, (ReadOnlyRegistry<Interceptor>)registry, messageExchange) - CoreSortingStrategy.this.getInterceptorPriority(o1, (ReadOnlyRegistry<Interceptor>)registry, messageExchange);
            }
        });
        return sorted;
    }

    @Override
    public int getPriority() {
        return 0;
    }
}

