/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swordfish.internal.core.planner;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swordfish.core.Interceptor;
import org.eclipse.swordfish.core.planner.strategy.FilterStrategy;
import org.eclipse.swordfish.core.planner.strategy.Hint;
import org.eclipse.swordfish.core.util.ReadOnlyRegistry;
import org.eclipse.swordfish.internal.core.planner.ScopeHint;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScopeFilterStrategy
implements FilterStrategy {
    private static final Log LOG = LogFactory.getLog(ScopeFilterStrategy.class);

    @Override
    public List<Interceptor> filter(List<Interceptor> interceptors, ReadOnlyRegistry<Interceptor> registry, List<Hint<?>> hints) {
        Object[] arguments = new Object[]{interceptors, registry, hints};
        Assert.noNullElements((Object[])arguments, (String)"Agruments passed to strategy mustn't be null.");
        ArrayList<Interceptor> validInterceptors = new ArrayList<Interceptor>();
        Collection<ScopeHint> filteredHints = this.filterHints(hints);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Filtering the interceptors with the followng list of hints: " + filteredHints));
        }
        if (filteredHints.size() != 0) {
            for (Interceptor interceptor : interceptors) {
                if (this.isValidInterceptor(interceptor, registry, filteredHints)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Adding interceptor " + interceptor + " to the list of valid interceptors."));
                    }
                    validInterceptors.add(interceptor);
                    continue;
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("Dropped interceptor " + interceptor + " from the list of valid interceptors."));
            }
        } else if (filteredHints.size() == 0) {
            LOG.warn((Object)"No suitable hints found, skipping filtering.");
        }
        return validInterceptors;
    }

    private Collection<ScopeHint> filterHints(Iterable<Hint<?>> hints) {
        ArrayList<ScopeHint> filteredHints = new ArrayList<ScopeHint>();
        for (Hint<?> hint : hints) {
            if (!ScopeHint.class.isAssignableFrom(hint.getClass())) continue;
            filteredHints.add((ScopeHint)ScopeHint.class.cast(hint));
        }
        return filteredHints;
    }

    private boolean isValidInterceptor(Interceptor interceptor, ReadOnlyRegistry<Interceptor> registry, Collection<ScopeHint> hints) {
        Map interceptorProperties = registry.getProperties((Object)interceptor);
        for (ScopeHint hint : hints) {
            Object hintProperties = hint.getInfo();
            if (!interceptorProperties.keySet().containsAll(hintProperties.keySet())) continue;
            boolean matches = true;
            for (Map.Entry entry : hintProperties.entrySet()) {
                String hintProperty = entry.getValue().toString().toLowerCase();
                String interceptorProperty = interceptorProperties.get(entry.getKey()).toString().toLowerCase();
                matches = interceptorProperty.contains(hintProperty);
                if (!matches) break;
            }
            if (!matches) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Hint " + hint + " accepted interceptor " + interceptor + "."));
            }
            return true;
        }
        return false;
    }

    @Override
    public FilterStrategy.StrategyType getStrategyType() {
        return FilterStrategy.StrategyType.SUBSTRACTING;
    }

    @Override
    public int getPriority() {
        return -1;
    }
}

