/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swordfish.internal.core.planner;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.jbi.messaging.MessageExchange;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swordfish.core.SwordfishException;
import org.eclipse.swordfish.core.planner.strategy.Hint;
import org.eclipse.swordfish.core.planner.strategy.HintExtractor;
import org.eclipse.swordfish.internal.core.planner.InterceptorRole;
import org.eclipse.swordfish.internal.core.planner.InterceptorScope;
import org.eclipse.swordfish.internal.core.planner.ScopeHint;
import org.eclipse.swordfish.internal.core.util.smx.ExchangeRole;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScopeHintExtractor
implements HintExtractor {
    private static final Log LOG = LogFactory.getLog(ScopeHintExtractor.class);

    @Override
    public List<Hint<?>> extractHints(MessageExchange messageExchange) {
        ArrayList hintsList = new ArrayList();
        HashMap<String, Enum> hintProps = new HashMap<String, Enum>();
        InterceptorScope scope = null;
        InterceptorRole role = null;
        try {
            ExchangeRole er = ExchangeRole.valueOf((MessageExchange)messageExchange);
            role = er == ExchangeRole.ConsumerRequest || er == ExchangeRole.ConsumerResponse ? InterceptorRole.CONSUMER : InterceptorRole.PROVIDER;
            scope = er == ExchangeRole.ConsumerRequest || er == ExchangeRole.ProviderRequest ? InterceptorScope.REQUEST : InterceptorScope.RESPONSE;
        }
        catch (Exception e) {
            LOG.error((Object)("Couldn't extract hint information from exchange: " + messageExchange), (Throwable)e);
            throw new SwordfishException("Couldn't extract hint information from exchange: " + messageExchange, (Throwable)e);
        }
        hintProps.put("role", role);
        hintProps.put("scope", scope);
        hintsList.add(new ScopeHint(hintProps));
        return hintsList;
    }
}

