/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swordfish.internal.core.util;

import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrderPreservingDictionary<K, V>
extends Dictionary<K, V>
implements Map<K, V> {
    private Map<K, V> data;

    public OrderPreservingDictionary() {
        this.data = new LinkedHashMap();
    }

    public OrderPreservingDictionary(Map<K, V> source) {
        this.data = new LinkedHashMap<K, V>(source);
    }

    public OrderPreservingDictionary(Dictionary<K, V> source) {
        this();
        if (source != null && source.size() > 0) {
            Enumeration<K> enm = source.keys();
            while (enm.hasMoreElements()) {
                K key = enm.nextElement();
                this.data.put(key, source.get(key));
            }
        }
    }

    @Override
    public Enumeration<V> elements() {
        return new IteratingEnumeration<V>(this.data.values().iterator());
    }

    @Override
    public V get(Object key) {
        this.assertNotNull(key, "Key");
        return this.data.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public Enumeration<K> keys() {
        return new IteratingEnumeration<K>(this.data.keySet().iterator());
    }

    @Override
    public V put(K key, V value) {
        this.assertNotNull(key, "Key");
        this.assertNotNull(value, "Value");
        this.data.put(key, value);
        return this.data.get(key);
    }

    @Override
    public V remove(Object key) {
        return this.data.remove(key);
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public void clear() {
        this.data.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.data.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.data.containsValue(value);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.data.entrySet();
    }

    @Override
    public Set<K> keySet() {
        return this.data.keySet();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> t) {
        this.data.putAll(t);
    }

    @Override
    public Collection<V> values() {
        return this.data.values();
    }

    private void assertNotNull(Object o, String itemName) {
        if (o == null) {
            throw new IllegalArgumentException(String.valueOf(itemName) + " must not be null");
        }
    }

    public String toString() {
        return this.data.toString();
    }

    @Override
    public boolean equals(Object obj) {
        return this.data.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.data.hashCode();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IteratingEnumeration<X>
    implements Enumeration<X> {
        private Iterator<X> embeddedIterator;

        public IteratingEnumeration(Iterator<X> base) {
            this.embeddedIterator = base;
        }

        @Override
        public boolean hasMoreElements() {
            return this.embeddedIterator.hasNext();
        }

        @Override
        public X nextElement() {
            return this.embeddedIterator.next();
        }
    }
}

