/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swordfish.internal.core.util;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionUtil {
    public static Object getField(Object instance, String fieldName) {
        return ReflectionUtil.getDeclaredField(instance, instance.getClass(), fieldName);
    }

    public static Object getDeclaredField(Object instance, Class<?> declaredClass, String fieldName) {
        try {
            Field field = declaredClass.getDeclaredField(fieldName);
            Assert.notNull((Object)field);
            field.setAccessible(true);
            return field.get(instance);
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    public static List<Object> getAnonymousClassInstanceValues(Object anonymousClassInstance) {
        try {
            ArrayList<Object> ret = new ArrayList<Object>();
            Field[] fieldArray = anonymousClassInstance.getClass().getDeclaredFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                field.setAccessible(true);
                ret.add(field.get(anonymousClassInstance));
                ++n2;
            }
            return ret;
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }
}

