/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swordfish.internal.core.integration.nmr;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jbi.messaging.MessageExchange;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.jbi.runtime.impl.MessageExchangeImpl;
import org.apache.servicemix.nmr.api.Exchange;
import org.apache.servicemix.nmr.api.Message;
import org.apache.servicemix.nmr.api.NMR;
import org.apache.servicemix.nmr.api.event.ExchangeListener;
import org.apache.servicemix.nmr.api.event.Listener;
import org.apache.servicemix.nmr.core.ExchangeImpl;
import org.eclipse.swordfish.core.Interceptor;
import org.eclipse.swordfish.core.SwordfishContext;
import org.eclipse.swordfish.core.SwordfishException;
import org.eclipse.swordfish.core.event.Event;
import org.eclipse.swordfish.core.planner.Planner;
import org.eclipse.swordfish.core.resolver.EndpointMetadata;
import org.eclipse.swordfish.core.util.Registry;
import org.eclipse.swordfish.internal.core.event.TrackingEventImpl;
import org.eclipse.swordfish.internal.core.exception.InterceptorExceptionNotificationSender;
import org.eclipse.swordfish.internal.core.util.smx.ExchangeRole;
import org.eclipse.swordfish.internal.core.util.smx.JbiConstants;
import org.eclipse.swordfish.internal.core.util.xml.XPathUtil;
import org.eclipse.swordfish.internal.core.util.xml.XmlUtil;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwordfishExchangeListener
implements ExchangeListener,
InitializingBean {
    private static final transient Log LOG = LogFactory.getLog(SwordfishExchangeListener.class);
    private NMR nmr;
    private Planner planner;
    private Interceptor endpointResolverInterceptor;
    private Registry<Interceptor> interceptorRegistry;
    private InterceptorExceptionNotificationSender exceptionNotificationSender;
    private SwordfishContext swordfishContext;

    public Registry<Interceptor> getInterceptorRegistry() {
        return this.interceptorRegistry;
    }

    public void setInterceptorRegistry(Registry<Interceptor> interceptorRegistry) {
        this.interceptorRegistry = interceptorRegistry;
    }

    public void exchangeDelivered(Exchange exchange) {
        LOG.debug((Object)("ExchangeDelivered exchangeId=" + exchange.getId()));
    }

    public InterceptorExceptionNotificationSender getExceptionNotificationSender() {
        return this.exceptionNotificationSender;
    }

    public void setExceptionNotificationSender(InterceptorExceptionNotificationSender exceptionNotificationSender) {
        this.exceptionNotificationSender = exceptionNotificationSender;
    }

    public void exchangeSent(Exchange exchange) {
        MessageExchangeImpl exchangeImpl = new MessageExchangeImpl(exchange);
        try {
            block7: {
                this.sendTrackingEvent(exchangeImpl);
                try {
                    this.endpointResolverInterceptor.process((MessageExchange)exchangeImpl, null);
                }
                catch (SwordfishException ex) {
                    LOG.warn((Object)"The EndpointResolver has thrown exception", (Throwable)ex);
                    this.exceptionNotificationSender.sendNotification((Exception)((Object)ex), (MessageExchange)exchangeImpl, this.endpointResolverInterceptor);
                    exchangeImpl.setError((Exception)((Object)ex));
                    this.sendTrackingEvent(exchangeImpl);
                    if (exchangeImpl.getRole() != MessageExchange.Role.CONSUMER) break block7;
                    throw ex;
                }
            }
            this.setMessageHeaders(exchangeImpl);
            List interceptors = this.planner.getInterceptorChain(this.interceptorRegistry.getKeySet(), (MessageExchange)exchangeImpl);
            for (Interceptor interceptor : interceptors) {
                try {
                    QName typeProperty = (QName)interceptor.getProperties().get("type");
                    Map contextProps = (Map)exchange.getProperty(typeProperty.toString());
                    interceptor.process((MessageExchange)exchangeImpl, contextProps);
                }
                catch (SwordfishException ex) {
                    LOG.warn((Object)"The interceptor has thrown exception", (Throwable)ex);
                    this.exceptionNotificationSender.sendNotification((Exception)((Object)ex), (MessageExchange)exchangeImpl, interceptor);
                    exchangeImpl.setError((Exception)((Object)ex));
                    this.sendTrackingEvent(exchangeImpl);
                    if (exchangeImpl.getRole() != MessageExchange.Role.CONSUMER) continue;
                    throw ex;
                }
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private void setMessageHeaders(MessageExchangeImpl me) {
        Exchange exchange = me.getInternalExchange();
        if (ExchangeRole.valueOf((MessageExchange)me) == ExchangeRole.ConsumerRequest) {
            this.processOutgoingRequestHeaders(exchange);
        } else if (ExchangeRole.valueOf((MessageExchange)me) == ExchangeRole.ProviderResponse) {
            this.processOutgoingResponseHeaders(exchange);
        }
    }

    private void processOutgoingRequestHeaders(Exchange exchange) {
        EndpointMetadata metadata = (EndpointMetadata)exchange.getProperty("org.eclipse.swordfish.core.resolver.EndpointMetadata");
        if (metadata == null) {
            return;
        }
        DocumentFragment policy = metadata.toXml();
        Document doc = XmlUtil.getDocumentBuilder().newDocument();
        Element replyTo = doc.createElementNS("http://www.w3.org/2005/08/addressing", "ReplyTo");
        replyTo.setPrefix("wsa");
        Element addr = doc.createElementNS("http://www.w3.org/2005/08/addressing", "Address");
        addr.setPrefix("wsa");
        addr.appendChild(doc.createTextNode("http://www.w3.org/2005/08/addressing/anonymous"));
        replyTo.appendChild(addr);
        Element refParams = doc.createElementNS("http://www.w3.org/2005/08/addressing", "ReferenceParameters");
        refParams.setPrefix("wsa");
        Node policyNode = doc.importNode(policy, true);
        refParams.appendChild(policyNode);
        replyTo.appendChild(refParams);
        DocumentFragment replyToHeader = doc.createDocumentFragment();
        replyToHeader.appendChild(replyTo);
        HashMap<QName, DocumentFragment> headers = new HashMap<QName, DocumentFragment>();
        QName policyKey = new QName(policy.getFirstChild().getNamespaceURI(), policy.getFirstChild().getLocalName());
        headers.put(policyKey, policy);
        headers.put(JbiConstants.WSA_REPLY_TO_QNAME, replyToHeader);
        exchange.getIn(false).setHeader("org.apache.servicemix.soap.headers", headers);
    }

    private void processOutgoingResponseHeaders(Exchange exchange) {
        Map inHeaders;
        Message inMessage = exchange.getIn(false);
        Message outMessage = exchange.getOut(false);
        if (inMessage == null || outMessage == null) {
            LOG.debug((Object)"Skip processing of SOAP headers for outgoing response.");
            return;
        }
        HashMap<QName, DocumentFragment> outHeaders = (HashMap<QName, DocumentFragment>)outMessage.getHeader("org.apache.servicemix.soap.headers");
        if (outHeaders == null) {
            outHeaders = new HashMap<QName, DocumentFragment>();
        }
        if ((inHeaders = (Map)inMessage.getHeader("org.apache.servicemix.soap.headers")) != null && inHeaders.containsKey(JbiConstants.WSA_REPLY_TO_QNAME)) {
            DocumentFragment replyToFrag = (DocumentFragment)inHeaders.get(JbiConstants.WSA_REPLY_TO_QNAME);
            Node refParams = XPathUtil.getElementByName((Node)replyToFrag, (QName)JbiConstants.WSA_REFERENCE_PARAMS_QNAME);
            NodeList params = refParams.getChildNodes();
            int i = 0;
            while (i < params.getLength()) {
                DocumentFragment fragment = XmlUtil.wrapWithDocumentFragment((Node)params.item(i));
                Node fragmentNode = fragment.getFirstChild();
                QName fragmentName = new QName(fragmentNode.getNamespaceURI(), fragmentNode.getLocalName());
                outHeaders.put(fragmentName, fragment);
                ++i;
            }
        }
        outMessage.setHeader("org.apache.servicemix.soap.headers", outHeaders);
    }

    private void sendTrackingEvent(MessageExchangeImpl me) {
        InternalEventExchange eventExchange = new InternalEventExchange(me.getInternalExchange());
        MessageExchangeImpl eventMessageExchange = new MessageExchangeImpl((Exchange)eventExchange);
        TrackingEventImpl trackingEvent = new TrackingEventImpl((MessageExchange)eventMessageExchange);
        this.swordfishContext.getEventService().postEvent((Event)trackingEvent);
    }

    public NMR getNmr() {
        return this.nmr;
    }

    public void setNmr(NMR nmr) {
        this.nmr = nmr;
    }

    public Planner getPlanner() {
        return this.planner;
    }

    public void setPlanner(Planner planner) {
        this.planner = planner;
    }

    public Interceptor getEndpointResolverInterceptor() {
        return this.endpointResolverInterceptor;
    }

    public void setEndpointResolverInterceptor(Interceptor endpointResolverInterceptor) {
        this.endpointResolverInterceptor = endpointResolverInterceptor;
    }

    protected void start() {
        this.nmr.getListenerRegistry().register((Listener)this, null);
    }

    public void setSwordfishContext(SwordfishContext swordfishContext) {
        this.swordfishContext = swordfishContext;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.nmr);
        Assert.notNull((Object)this.planner);
        Assert.notNull(this.interceptorRegistry);
        Assert.notNull((Object)this.swordfishContext);
        this.start();
    }

    public void exchangeFailed(Exchange arg0) {
    }

    private class InternalEventExchange
    extends ExchangeImpl {
        private String exchangeId;

        public InternalEventExchange(Exchange exchange) {
            super(exchange.getPattern());
            this.exchangeId = exchange.getId();
            this.copyFrom(exchange);
            this.setOperation(exchange.getOperation());
            this.setStatus(exchange.getStatus());
        }

        public String getId() {
            return this.exchangeId;
        }
    }
}

