/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swordfish.plugins.cxf.support;

import java.io.OutputStream;
import java.lang.reflect.Field;
import org.apache.cxf.Bus;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.servicemix.cxf.transport.nmr.NMRConduit;
import org.apache.servicemix.cxf.transport.nmr.NMRConduitOutputStream;
import org.apache.servicemix.nmr.api.Channel;
import org.eclipse.swordfish.plugins.cxf.support.NMROutputStream;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NMRStreamReplacingInterceptor
extends AbstractPhaseInterceptor<Message>
implements InitializingBean {
    private Bus cxf;

    public NMRStreamReplacingInterceptor() {
        super("pre-stream");
    }

    private Object getFieldValue(Object obj, String fieldName) {
        try {
            Field field = obj.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            return field.get(obj);
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex.getMessage(), ex);
        }
    }

    public void handleMessage(Message message) throws Fault {
        Object object = message.getContent(OutputStream.class);
        if (object instanceof NMRConduitOutputStream) {
            NMRConduitOutputStream conduitOutputStream = (NMRConduitOutputStream)object;
            Message messageToHandle = (Message)this.getFieldValue(conduitOutputStream, "message");
            Channel channel = (Channel)this.getFieldValue(conduitOutputStream, "channel");
            NMRConduit conduit = (NMRConduit)this.getFieldValue(conduitOutputStream, "conduit");
            EndpointReferenceType target = (EndpointReferenceType)this.getFieldValue(conduitOutputStream, "target");
            message.setContent(OutputStream.class, (Object)new NMROutputStream(messageToHandle, channel.getNMR(), target, conduit));
        }
    }

    public Bus getCxf() {
        return this.cxf;
    }

    public void setCxf(Bus cxf) {
        this.cxf = cxf;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.cxf);
        this.cxf.getOutInterceptors().add(this);
    }
}

