/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swordfish.plugins.planner.policy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.neethi.Assertion;
import org.apache.neethi.Policy;
import org.eclipse.swordfish.core.planner.strategy.Hint;
import org.eclipse.swordfish.core.planner.strategy.HintExtractor;
import org.eclipse.swordfish.core.resolver.policy.PolicyExtractor;
import org.eclipse.swordfish.plugins.planner.policy.AssertionHint;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicyAssertionHintExtractor
implements HintExtractor {
    private static final QName POLICY_HEADER = new QName("http://schemas.xmlsoap.org/ws/2004/09/policy", "Policy");
    private static final Log LOG = LogFactory.getLog(PolicyAssertionHintExtractor.class);
    private static final List<Hint<?>> EMPTY_LIST = Collections.emptyList();
    private PolicyExtractor policyExtractor;

    public PolicyExtractor getPolicyExtractor() {
        return this.policyExtractor;
    }

    public void setPolicyExtractor(PolicyExtractor policyExtractor) {
        this.policyExtractor = policyExtractor;
    }

    public List<Hint<?>> extractHints(MessageExchange messageExchange) {
        List<Hint<?>> hints = EMPTY_LIST;
        if (messageExchange.getStatus() != ExchangeStatus.ACTIVE) {
            LOG.warn((Object)"Couldn't extract hints from terminated (status == DONE) message exchange!");
            return hints;
        }
        Policy policy = this.getPolicy(messageExchange);
        if (policy != null) {
            hints = this.extractAssertions(policy);
        }
        return hints;
    }

    private Policy getPolicy(MessageExchange messageExchange) {
        Element policyElement;
        block7: {
            DocumentFragment policyFragment;
            block6: {
                Map headers;
                block5: {
                    Policy policy = null;
                    try {
                        NormalizedMessage message = this.getNormalizedMessage(messageExchange);
                        headers = (Map)message.getProperty("org.apache.servicemix.soap.headers");
                        if (headers != null) break block5;
                        return null;
                    }
                    catch (Exception ex) {
                        LOG.warn((Object)ex.getMessage(), (Throwable)ex);
                        return policy;
                    }
                }
                policyFragment = (DocumentFragment)headers.get(POLICY_HEADER);
                if (policyFragment != null) break block6;
                return null;
            }
            policyElement = (Element)policyFragment.getFirstChild();
            if ("Policy".equals(policyElement.getLocalName()) && "http://schemas.xmlsoap.org/ws/2004/09/policy".equals(policyElement.getNamespaceURI())) break block7;
            return null;
        }
        return this.policyExtractor.extractPolicy(policyElement);
    }

    private NormalizedMessage getNormalizedMessage(MessageExchange exchange) {
        String messageId = exchange.getRole().equals(MessageExchange.Role.CONSUMER) ? "in" : "out";
        return exchange.getMessage(messageId);
    }

    public List<Hint<?>> extractAssertions(Policy policy) {
        ArrayList assertions = new ArrayList();
        Iterator alternativesIter = policy.getAlternatives();
        if (alternativesIter.hasNext()) {
            Iterable alternative = (Iterable)alternativesIter.next();
            for (Assertion assertion : alternative) {
                assertions.add(new AssertionHint<Assertion>(assertion));
            }
        }
        return assertions;
    }
}

