/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swordfish.internal.resolver.backend.base.wsdl11;

import java.util.Iterator;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap12.SOAP12Address;
import javax.wsdl.extensions.soap12.SOAP12Binding;
import org.eclipse.swordfish.core.resolver.EndpointDescription;
import org.eclipse.swordfish.core.resolver.registry.EndpointExtractor;
import org.eclipse.swordfish.core.resolver.registry.ServiceDescription;
import org.eclipse.swordfish.internal.resolver.backend.base.wsdl.WSDLEndpointDescription;
import org.eclipse.swordfish.internal.resolver.backend.base.wsdl11.WSDL11ServiceDescription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDL11EndpointExtractor
implements EndpointExtractor {
    private Class<Definition> descriptionType = Definition.class;

    public boolean canHandle(ServiceDescription<?> description) {
        return description != null && this.descriptionType.equals(description.getType());
    }

    public EndpointDescription extractEndpoint(ServiceDescription<?> serviceDescription) {
        WSDLEndpointDescription endpoint = new WSDLEndpointDescription();
        WSDL11ServiceDescription wsdlDescription = null;
        String endpointAddress = null;
        String endpointTransport = null;
        if (serviceDescription == null) {
            throw new IllegalArgumentException("ServiceDescription argument can not be null.");
        }
        wsdlDescription = (WSDL11ServiceDescription)WSDL11ServiceDescription.class.cast(serviceDescription);
        Map<ExtensibilityElement, ExtensibilityElement> locations = wsdlDescription.getAvailableLocations();
        Iterator<Map.Entry<ExtensibilityElement, ExtensibilityElement>> iterator = locations.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry<ExtensibilityElement, ExtensibilityElement> entry = iterator.next();
            ExtensibilityElement address = entry.getKey();
            ExtensibilityElement binding = entry.getValue();
            if (address instanceof SOAPAddress) {
                endpointAddress = ((SOAPAddress)address).getLocationURI();
            }
            if (address instanceof SOAP12Address) {
                endpointAddress = ((SOAP12Address)address).getLocationURI();
            }
            if (endpointAddress == null) {
                throw new IllegalStateException("Couldn't extract endpoint address.");
            }
            endpoint.setAddress(String.valueOf(endpointAddress) + "?http.soap=true");
            if (binding instanceof SOAPBinding) {
                endpointTransport = ((SOAPBinding)binding).getTransportURI();
            }
            if (binding instanceof SOAP12Binding) {
                endpointTransport = ((SOAP12Binding)binding).getTransportURI();
            }
            if (endpointTransport != null) {
                endpoint.setEndpointTransport(endpointTransport);
            } else {
                throw new IllegalStateException("Couldn't determine endpoint transport.");
            }
        }
        endpoint.setServiceDescription(serviceDescription);
        endpoint.setName(wsdlDescription.getPortName(endpointAddress, endpointTransport));
        return endpoint;
    }
}

