/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swordfish.internal.resolver.backend.local;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swordfish.core.SwordfishException;
import org.eclipse.swordfish.core.resolver.registry.ServiceDescription;
import org.eclipse.swordfish.internal.resolver.backend.base.AbstractDocumentProvider;
import org.eclipse.swordfish.internal.resolver.backend.base.wsdl11.WSDL11ServiceDescription;
import org.eclipse.swordfish.internal.resolver.backend.local.WSDLManager;
import org.eclipse.swordfish.internal.resolver.backend.local.WSDLManagerImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilesystemDocumentProvider
extends AbstractDocumentProvider {
    private static final Log LOG = LogFactory.getLog(FilesystemDocumentProvider.class);
    private static final String WSDL_STORAGE_PROPERTY = "wsdlStorage";
    private WSDLManager wsdlManager;

    public List<ServiceDescription<?>> getServiceProviderDescriptions(QName interfaceName) {
        ArrayList descriptions = new ArrayList();
        try {
            Collection<Definition> definitions = this.wsdlManager.getDefinitions(interfaceName);
            if (definitions != null) {
                for (Definition definition : definitions) {
                    WSDL11ServiceDescription description = new WSDL11ServiceDescription(definition);
                    descriptions.add((ServiceDescription<?>)description);
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)("Successfully retrieved service description: " + description.getServiceName() + " for portType: " + interfaceName));
                }
            }
        }
        catch (WSDLException e) {
            LOG.error((Object)("Error resolving endpoint - couldn't retrieve service description for port type " + interfaceName), (Throwable)e);
            throw new SwordfishException("Error resolving endpoint - couldn't retrieve service description for port type " + interfaceName + " message: " + e.getMessage());
        }
        return descriptions;
    }

    public void onReceiveConfiguration(Map<String, Object> configuration) {
        super.onReceiveConfiguration(configuration);
        if (configuration != null && configuration.containsKey(WSDL_STORAGE_PROPERTY)) {
            try {
                List resourcesToLoad = (List)configuration.get(WSDL_STORAGE_PROPERTY);
                this.wsdlManager = new WSDLManagerImpl();
                for (String nextResource : resourcesToLoad) {
                    URL resourceUrl = new URL(nextResource);
                    this.wsdlManager.setupWSDLs(resourceUrl);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Successfully initialized WSDL manager");
                }
            }
            catch (MalformedURLException e) {
                LOG.error((Object)"Couldn't initialize filesystem document provider: malformed WSDL location specified.", (Throwable)e);
                throw new IllegalArgumentException("Couldn't initialize filesystem document provider: malformed WSDL location specified.", e);
            }
            catch (WSDLException e) {
                LOG.error((Object)"Couldn't initialize filesystem document provider: an error occured during intialization of WSDL manager.", (Throwable)e);
                throw new IllegalStateException("Couldn't initialize filesystem document provider: an error occured during intialization of WSDL manager.", e);
            }
            catch (IOException e) {
                LOG.error((Object)"Couldn't initialize filesystem document provider: an error occured during intialization of WSDL manager.", (Throwable)e);
                throw new IllegalStateException("Couldn't initialize filesystem document provider: an error occured during intialization of WSDL manager.", e);
            }
        }
    }

    public WSDLManager getWsdlManager() {
        return this.wsdlManager;
    }
}

