/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swordfish.internal.resolver.backend.remote;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swordfish.core.SwordfishException;
import org.eclipse.swordfish.core.resolver.backend.ClientRequest;
import org.eclipse.swordfish.core.resolver.backend.ClientResponse;
import org.eclipse.swordfish.core.resolver.backend.ProxyConstants;
import org.eclipse.swordfish.core.resolver.backend.RegistryProxy;
import org.eclipse.swordfish.core.resolver.registry.ServiceDescription;
import org.eclipse.swordfish.internal.resolver.backend.base.AbstractDocumentProvider;
import org.eclipse.swordfish.internal.resolver.backend.base.RegistryProxyFactory;
import org.eclipse.swordfish.internal.resolver.backend.base.wsdl.ServiceDescriptionReader;
import org.eclipse.swordfish.internal.resolver.backend.base.wsdl.WSDLList;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwordfishRegistryProvider
extends AbstractDocumentProvider {
    private static final Log LOG = LogFactory.getLog(SwordfishRegistryProvider.class);
    private static final String REGISTRY_URL_PROPERTY = "registryURL";
    public static final String REGISTRY_URL_SYSPROPERTY = "org.eclipse.swordfish.registry.url";
    public static final String DESCRIPTION_CONTEXT = "wsdl";
    private URL registryURL;
    private RegistryProxy proxy;
    private ServiceDescriptionReader<?> wsdlReader;

    public List<ServiceDescription<?>> getServiceProviderDescriptions(QName interfaceName) {
        ArrayList descriptions = new ArrayList();
        try {
            this.checkProperties();
            URL descripionBaseUrl = this.getResourceUrl(this.getRegistryURL().toString(), DESCRIPTION_CONTEXT);
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("type", "portType");
            properties.put("targetNamespace", interfaceName.getNamespaceURI());
            properties.put("name", interfaceName.getLocalPart());
            ClientRequest request = RegistryProxyFactory.getInstance().createRequest();
            request.setURI(descripionBaseUrl.toURI());
            request.setProperties(properties);
            request.setEntityType(WSDLList.class);
            ClientResponse response = this.getProxy().get(request);
            if (!response.getStatus().equals((Object)ProxyConstants.Status.SUCCESS)) {
                this.handleFailure(response);
            }
            WSDLList descriptionUrls = (WSDLList)WSDLList.class.cast(response.getEntity());
            for (String url : descriptionUrls.getUrl()) {
                URL nextDescriptionUrl = this.getResourceUrl(descripionBaseUrl.toString(), url);
                ServiceDescription description = this.getWsdlReader().readDescription(nextDescriptionUrl);
                descriptions.add(description);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("Successfully retrieved service description: " + description.getServiceName() + " for portType: " + interfaceName));
            }
        }
        catch (SwordfishException se) {
            throw se;
        }
        catch (Exception e) {
            LOG.error((Object)("Error resolving endpoint - couldn't retrieve service description for port type " + interfaceName), (Throwable)e);
            throw new SwordfishException("Error resolving endpoint - couldn't retrieve service description for port type " + interfaceName, (Throwable)e);
        }
        return descriptions;
    }

    public void onReceiveConfiguration(Map<String, Object> configuration) {
        super.onReceiveConfiguration(configuration);
        if (System.getProperty(REGISTRY_URL_SYSPROPERTY) != null) {
            try {
                URL registryUrlSystemProperty = new URL(System.getProperty(REGISTRY_URL_SYSPROPERTY));
                this.setRegistryURL(registryUrlSystemProperty);
            }
            catch (MalformedURLException e) {
                LOG.error((Object)"Couldn't initialize Swordfish registry proxy: malformed registry URL specified in the system property", (Throwable)e);
                throw new IllegalArgumentException("Couldn't initialize Swordfish registry proxy: malformed registry URL specified in the system property", e);
            }
        }
        if (configuration != null && configuration.containsKey(REGISTRY_URL_PROPERTY)) {
            try {
                this.setRegistryURL(new URL((String)configuration.get(REGISTRY_URL_PROPERTY)));
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Service registry URL has been set to: " + this.getRegistryURL()));
                }
            }
            catch (MalformedURLException e) {
                LOG.error((Object)"Couldn't initialize Swordfish registry proxy: malformed registry URL specified", (Throwable)e);
                throw new IllegalArgumentException("Couldn't initialize Swordfish registry proxy: malformed registry URL specified", e);
            }
        }
    }

    private void handleFailure(ClientResponse response) {
        SwordfishException exception = null;
        Throwable remoteException = null;
        if (response.getEntity() != null && Throwable.class.isAssignableFrom(response.getEntity().getClass())) {
            remoteException = (Throwable)response.getEntity();
        }
        exception = response.getStatus().equals((Object)ProxyConstants.Status.ERROR) ? new SwordfishException("Service registry is not accessible on URL " + this.getRegistryURL(), remoteException) : (response.getStatus().equals((Object)ProxyConstants.Status.NOT_FOUND) ? new SwordfishException("Service description has not been found in service registry", remoteException) : (response.getStatus().equals((Object)ProxyConstants.Status.MALFORMED_QUERY) ? new SwordfishException("Request has not been recognized by remote registry - wrong query specified", remoteException) : new SwordfishException("Error resolving endpoint - cannot retrieve service description", remoteException)));
        throw exception;
    }

    private void checkProperties() {
        Object[] props = new Object[]{this.getRegistryURL(), this.getProxy(), this.getWsdlReader()};
        Assert.noNullElements((Object[])props, (String)"Service registry properties are not initialized.");
    }

    private URL getResourceUrl(String registryBaseURL, String relativeURL) throws MalformedURLException {
        StringBuilder descripionBaseUrl = new StringBuilder(registryBaseURL);
        if (!registryBaseURL.endsWith("/")) {
            descripionBaseUrl.append("/");
        }
        if (relativeURL.startsWith(".")) {
            relativeURL = relativeURL.substring(1);
        }
        if (relativeURL.startsWith("/")) {
            relativeURL = relativeURL.substring(1);
        }
        descripionBaseUrl.append(relativeURL);
        return new URL(descripionBaseUrl.toString());
    }

    public URL getRegistryURL() {
        return this.registryURL;
    }

    public void setRegistryURL(URL registryURL) {
        this.registryURL = registryURL;
    }

    public RegistryProxy getProxy() {
        return this.proxy;
    }

    public void setProxy(RegistryProxy proxy) {
        this.proxy = proxy;
    }

    public ServiceDescriptionReader<?> getWsdlReader() {
        return this.wsdlReader;
    }

    public void setWsdlReader(ServiceDescriptionReader<?> wsdlReader) {
        this.wsdlReader = wsdlReader;
    }
}

