/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swordfish.registry;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import javax.wsdl.WSDLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swordfish.registry.InMemoryRepository;
import org.eclipse.swordfish.registry.InvalidFormatException;
import org.eclipse.swordfish.registry.PersistentData;
import org.eclipse.swordfish.registry.RegistryException;
import org.eclipse.swordfish.registry.Resource;
import org.eclipse.swordfish.registry.WSDLResource;
import org.eclipse.swordfish.registry.WSDLResourceReader;
import org.eclipse.swordfish.registry.domain.Definition;
import org.eclipse.swordfish.registry.domain.DefinitionImpl;
import org.eclipse.swordfish.registry.domain.WSDLCreator;

public class FileBasedWSDLManager
implements WSDLResourceReader {
    private static final Log LOGGER = LogFactory.getLog(FileBasedWSDLManager.class);
    private static final String LOCATION_PROPERTY = "org.eclipse.swordfish.registry.fileLocation";
    private File wsdlDirectory;
    private InMemoryRepository repos;
    private WSDLCreator wsdlCreator;

    FileBasedWSDLManager() {
    }

    public void setRepository(InMemoryRepository repository) {
        this.repos = repository;
    }

    public void setDirectory(String directoryName) throws RegistryException {
        this.setDirectory(new File(directoryName));
    }

    public void setWsdlCreator(WSDLCreator creator) {
        this.wsdlCreator = creator;
    }

    public void setDirectory(File directory) throws RegistryException {
        if (!directory.exists() || !directory.isDirectory()) {
            throw new RegistryException("The directory " + directory.getAbsolutePath() + " specified to contain the registry WSDL's does either not exist or is not a directory.");
        }
        this.wsdlDirectory = directory;
    }

    public void fill() throws RegistryException {
        File[] files;
        this.ensureDirectoryDefined();
        File[] fileArray = files = this.wsdlDirectory.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            try {
                this.add(file.getName(), new FileReader(file));
            }
            catch (InvalidFormatException e) {
                LOGGER.warn((Object)("File " + file.getAbsolutePath() + " is not a valid WSDL: " + e.getMessage()));
            }
            catch (IOException e) {
                LOGGER.warn((Object)("Unable to load file " + file.getAbsolutePath()), (Throwable)e);
            }
            ++n2;
        }
    }

    public Resource getResource(String id) {
        File location = new File(this.wsdlDirectory, id);
        return new WSDLResource(new FileData(location));
    }

    public void add(String id, Reader reader) throws InvalidFormatException, IOException {
        javax.wsdl.Definition wsdl4jDef = null;
        try {
            wsdl4jDef = this.wsdlCreator.definition(reader);
        }
        catch (WSDLException e) {
            throw new InvalidFormatException(e);
        }
        DefinitionImpl definition = new DefinitionImpl(id, wsdl4jDef);
        this.delete(id);
        definition.register(this.repos);
    }

    public void delete(String id) {
        Definition wsdlDefinition = this.repos.getWSDLDefinitionById(id);
        if (wsdlDefinition != null) {
            wsdlDefinition.deregister(this.repos);
        }
    }

    private void ensureDirectoryDefined() throws RegistryException {
        if (this.wsdlDirectory == null) {
            String fileLocation = System.getProperty(LOCATION_PROPERTY);
            if (fileLocation == null) {
                throw new RegistryException("The system property org.eclipse.swordfish.registry.fileLocation is not defined.");
            }
            this.setDirectory(fileLocation);
        }
    }

    private static void swap(Reader reader, Writer writer) throws IOException {
        char[] buffer = new char[4000];
        int length = 0;
        do {
            if ((length = reader.read(buffer)) <= 0) continue;
            writer.write(buffer, 0, length);
        } while (length >= 0);
    }

    class FileData
    implements PersistentData {
        private File file;

        FileData(File file) {
            this.file = file;
        }

        public boolean isExisting() {
            return this.file.exists();
        }

        public String getId() {
            return this.file.getName();
        }

        public void read(Writer writer) throws IOException {
            FileBasedWSDLManager.swap(new FileReader(this.file), writer);
        }

        public InputStream read() throws IOException {
            return new FileInputStream(this.file);
        }

        public void write(Reader reader) throws InvalidFormatException, IOException {
            ByteArrayOutputStream arrayOutputStream = new ByteArrayOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter(new BufferedOutputStream(arrayOutputStream));
            try {
                FileBasedWSDLManager.swap(reader, writer);
            }
            finally {
                ((Writer)writer).flush();
                ((Writer)writer).close();
                reader.close();
            }
            byte[] fileContent = arrayOutputStream.toByteArray();
            boolean success = false;
            try {
                try {
                    FileBasedWSDLManager.this.add(this.file.getName(), new InputStreamReader(new BufferedInputStream(new ByteArrayInputStream(fileContent))));
                    success = true;
                }
                catch (InvalidFormatException e) {
                    throw e;
                }
                catch (IOException e) {
                    throw e;
                }
            }
            finally {
                if (success) {
                    FileWriter fileWriter = new FileWriter(this.file);
                    try {
                        FileBasedWSDLManager.swap(new InputStreamReader(new BufferedInputStream(new ByteArrayInputStream(fileContent))), fileWriter);
                    }
                    finally {
                        ((Writer)fileWriter).flush();
                        ((Writer)fileWriter).close();
                    }
                }
            }
        }

        public OutputStream write() throws IOException {
            return new FileOutputStream(this.file);
        }

        public void delete() {
            FileBasedWSDLManager.this.delete(this.file.getName());
            this.file.delete();
        }
    }
}

