/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swordfish.registry;

import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.eclipse.swordfish.registry.DefaultResource;
import org.eclipse.swordfish.registry.Resource;
import org.eclipse.swordfish.registry.VerbNotSupportedException;
import org.eclipse.swordfish.registry.domain.Definition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListResource<T extends Definition>
extends DefaultResource
implements Resource {
    private final Collection<T> resources;

    public ListResource() {
        this.resources = Collections.emptyList();
    }

    public ListResource(Collection<T> resources) {
        this.resources = resources;
    }

    public ListResource(Iterable<? extends T> resources) {
        this.resources = new HashSet<T>();
        for (Definition resource : resources) {
            this.resources.add(resource);
        }
    }

    @Override
    public String getId() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public String getContentType() {
        return "application/xml";
    }

    @Override
    public String getCharacterEncoding() {
        return "UTF-8";
    }

    @Override
    public void get(Writer writer) throws VerbNotSupportedException, IOException {
        this.appendContent(writer);
    }

    @Override
    @Deprecated
    public void appendContent(Writer writer) throws IOException {
        StringBuffer response = new StringBuffer(1000);
        response.append("<wsdlList>\n");
        for (Definition resource : this.resources) {
            response.append("  <url>./" + resource.getId() + "</url>\n");
        }
        response.append("</wsdlList>\n");
        writer.append(response);
    }
}

