/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swordfish.registry;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swordfish.registry.IncorrectRequestException;
import org.eclipse.swordfish.registry.InvalidFormatException;
import org.eclipse.swordfish.registry.Resource;
import org.eclipse.swordfish.registry.Router;
import org.eclipse.swordfish.registry.VerbNotSupportedException;

public class WSDLServlet
extends HttpServlet {
    private static final long serialVersionUID = -8376659320998034145L;
    private static final Log LOGGER = LogFactory.getLog(WSDLServlet.class);
    private Router router;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        LOGGER.info((Object)("Received GET request:\n" + req.getRequestURL()));
        Resource resource = null;
        try {
            resource = this.router.getResource(req);
        }
        catch (IncorrectRequestException e) {
            resp.sendError(e.getErrorCode(), e.getErrorMessage());
            return;
        }
        try {
            resp.setContentType(resource.getContentType());
            resp.setCharacterEncoding(resource.getCharacterEncoding());
            resource.get(resp.getWriter());
        }
        catch (VerbNotSupportedException verbNotSupportedException) {
            resp.sendError(400, "GET is not supported for " + req.getRequestURL());
            return;
        }
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        LOGGER.info((Object)("Received PUT request:\n" + req.getRequestURL()));
        Resource resource = null;
        try {
            resource = this.router.getResource(req);
        }
        catch (IncorrectRequestException e) {
            resp.sendError(e.getErrorCode(), e.getErrorMessage());
            return;
        }
        try {
            resource.put(req.getReader());
        }
        catch (InvalidFormatException invalidFormatException) {
            resp.sendError(400, "Body does not contain a valid WSDL.");
            return;
        }
        catch (VerbNotSupportedException verbNotSupportedException) {
            resp.sendError(400, "PUT is not supported for " + req.getRequestURL());
        }
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        LOGGER.info((Object)("Received DELETE request:\n" + req.getRequestURL()));
        Resource resource = null;
        try {
            resource = this.router.getResource(req);
        }
        catch (IncorrectRequestException e) {
            resp.sendError(e.getErrorCode(), e.getErrorMessage());
            return;
        }
        try {
            resource.delete();
        }
        catch (VerbNotSupportedException verbNotSupportedException) {
            resp.sendError(400, "DELETE is not supported for " + req.getRequestURL());
            return;
        }
    }

    public void setRouter(Router router) {
        this.router = router;
    }
}

