/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swordfish.registry.domain;

import java.io.PrintWriter;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionDeserializer;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.extensions.ExtensionSerializer;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import org.eclipse.swordfish.registry.domain.PolicyExtension;
import org.eclipse.swordfish.registry.domain.PolicyExtensionImpl;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;

public class PolicyExtensionSerializer
implements ExtensionDeserializer,
ExtensionSerializer {
    public static final String WSDL_NS = "http://schemas.xmlsoap.org/wsdl/";
    public static final String REQUIRED_ATTR = "required";
    private DocumentBuilder docBuilder;

    public PolicyExtensionSerializer(DocumentBuilder docBuilder) {
        this.docBuilder = docBuilder;
    }

    public ExtensibilityElement unmarshall(Class parentType, QName elementType, Element el, Definition def, ExtensionRegistry extReg) throws WSDLException {
        System.out.println("PolicyExtensionSerializer::unmarshall" + el);
        PolicyExtensionImpl policyExt = new PolicyExtensionImpl();
        policyExt.setRequired(this.checkIsRequired(el));
        policyExt.setId(this.retrieveId(el));
        policyExt.setPolicy(this.serialize(el));
        return policyExt;
    }

    public void marshall(Class parentType, QName elementType, ExtensibilityElement extension, PrintWriter pw, Definition def, ExtensionRegistry extReg) throws WSDLException {
        PolicyExtension policyExt = (PolicyExtension)extension;
        pw.append(policyExt.getPolicy());
    }

    String serialize(Node node) {
        LSSerializer serializer = this.getSerializer();
        return serializer.writeToString(node);
    }

    public LSSerializer getSerializer() {
        DOMImplementation domImpl = this.docBuilder.getDOMImplementation();
        DOMImplementationLS domImplLS = (DOMImplementationLS)domImpl.getFeature("LS", "3.0");
        return domImplLS.createLSSerializer();
    }

    private String retrieveId(Element el) {
        String idAttr = el.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
        if (idAttr.length() > 0) {
            return idAttr;
        }
        return null;
    }

    private Boolean checkIsRequired(Element el) {
        String required = el.getAttributeNS(WSDL_NS, REQUIRED_ATTR);
        if (required.length() > 0) {
            return new Boolean(required);
        }
        return null;
    }
}

