/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swordfish.tooling.server.core.operations;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.httpclient.HttpException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swordfish.tooling.server.core.P2Helper;
import org.eclipse.swordfish.tooling.server.core.SwordfishClient;
import org.eclipse.swordfish.tooling.server.core.SwordfishConstants;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.model.PublishOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DeployableOperation
extends PublishOperation {
    protected IServer server;
    protected Map<Integer, List<IModule>> modules;
    protected int kind;
    protected P2Helper p2Helper;
    static final int defaultPort = 9001;
    static final String defaultRepository = "SwordfishRepository";

    public DeployableOperation(IServer server, Map<Integer, List<IModule>> modules, int kind) {
        this.server = server;
        this.modules = modules;
        this.kind = kind;
        this.p2Helper = new P2Helper();
        this.p2Helper.setFeatureModels(modules, kind);
    }

    public List<IModule> getModules(int deltaKind) {
        return this.modules.get(deltaKind);
    }

    public int getOrder() {
        return 0;
    }

    public int getKind() {
        return 2;
    }

    public String getIUs(int deltaKind) {
        return this.p2Helper.getIuIds(deltaKind);
    }

    public String getProfile() {
        return null;
    }

    public abstract String getOperationId();

    public Map<String, String> getParameters() {
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        for (Integer deltaKind : this.modules.keySet()) {
            if (deltaKind != 3) {
                parameters.put("update", this.getIUs(deltaKind));
                continue;
            }
            parameters.put("remove", this.getIUs(deltaKind));
        }
        parameters.put("iuTargetProfile", this.getProfile());
        return parameters;
    }

    public void execute(IProgressMonitor monitor, IAdaptable info) throws CoreException {
        try {
            SwordfishClient client = this.getSwordfishClient();
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            int statusCode = client.call(this.getParameters(), null, bos);
            System.out.println("status: " + statusCode);
        }
        catch (HttpException e) {
            e.printStackTrace();
            throw new CoreException(null);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new CoreException(null);
        }
    }

    protected SwordfishClient getSwordfishClient() {
        String hostname = this.server.getHost();
        int colonPos = hostname.indexOf(":");
        if (colonPos < 0) {
            hostname = String.valueOf(hostname) + ":9001";
        }
        if (colonPos == hostname.length() - 1) {
            hostname = String.valueOf(hostname) + 9001;
        }
        String repository = SwordfishConstants.repository != null ? SwordfishConstants.repository : defaultRepository;
        String pathname = "/p2/provisioning/" + repository;
        return new SwordfishClient("http://" + hostname, pathname);
    }
}

