/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swordfish.tooling.server.core.operations;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.zip.ZipOutputStream;
import org.apache.commons.httpclient.HttpException;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.pde.internal.core.exports.FeatureExportInfo;
import org.eclipse.pde.internal.core.exports.FeatureExportOperation;
import org.eclipse.pde.internal.core.feature.WorkspaceFeatureModel;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.swordfish.tooling.server.core.AntErrorDialog;
import org.eclipse.swordfish.tooling.server.core.Messages;
import org.eclipse.swordfish.tooling.server.core.P2Helper;
import org.eclipse.swordfish.tooling.server.core.SwordfishClient;
import org.eclipse.swordfish.tooling.server.core.operations.DeployableOperation;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressConstants;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiOperation
extends DeployableOperation {
    private static final String ZIP = ".zip";
    private static final String LOGS_ZIP = "logs.zip";
    private static final String ZIP_FILENAME = "tempRepository";
    private File tempDir;

    public MultiOperation(IServer server, Map<Integer, List<IModule>> modules, int kind) {
        super(server, modules, kind);
    }

    @Override
    public void execute(IProgressMonitor monitor, IAdaptable adaptableInfo) throws CoreException {
        int tempDirNr = new Random().nextInt();
        String javaTmpDir = System.getProperty("java.io.tmpdir");
        this.tempDir = new File(String.valueOf(javaTmpDir) + File.separator + ZIP_FILENAME + "_" + tempDirNr);
        final FeatureExportInfo info = new FeatureExportInfo();
        info.toDirectory = true;
        info.useJarFormat = true;
        info.exportSource = false;
        info.exportSourceBundle = false;
        info.exportMetadata = true;
        info.allowBinaryCycles = true;
        info.useWorkspaceCompiledClasses = false;
        info.destinationDirectory = this.tempDir.getAbsolutePath();
        info.zipFileName = "tempRepository.zip";
        List<WorkspaceFeatureModel> models = this.p2Helper.getDeployableModels();
        info.items = models.toArray();
        final FeatureExportOperation job = new FeatureExportOperation(info, "");
        job.setUser(true);
        job.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        job.setProperty(IProgressConstants.ICON_PROPERTY, (Object)PDEPluginImages.DESC_FEATURE_OBJ);
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (job.hasAntErrors()) {
                    final File logLocation = new File(info.destinationDirectory, MultiOperation.LOGS_ZIP);
                    if (logLocation.exists()) {
                        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                            public void run() {
                                AntErrorDialog dialog = new AntErrorDialog(logLocation);
                                dialog.open();
                            }
                        });
                    }
                } else if (event.getResult().isOK()) {
                    new PublishToServerJob(MultiOperation.this.p2Helper, MultiOperation.this.tempDir).schedule();
                }
            }
        });
        job.schedule();
    }

    @Override
    public String getOperationId() {
        return "install";
    }

    private final class PublishToServerJob
    extends Job {
        private static final String PLUGIN_ID = "SwordfishDeployer";
        protected P2Helper p2Helper;
        private File tempDir;

        public PublishToServerJob(P2Helper p2Helper, File tempDir) {
            super(Messages.MultiOperation_OperationName);
            this.p2Helper = p2Helper;
            this.tempDir = tempDir;
        }

        protected IStatus run(IProgressMonitor monitor) {
            block26: {
                int statusCode;
                InputStream is;
                block23: {
                    Status status;
                    block24: {
                        SwordfishClient client = MultiOperation.this.getSwordfishClient();
                        is = null;
                        if (this.p2Helper.hasNonDeleteOperation()) {
                            ByteArrayOutputStream baos;
                            block22: {
                                baos = new ByteArrayOutputStream();
                                try {
                                    ZipOutputStream zos = new ZipOutputStream(baos);
                                    P2Helper.addFolder(this.tempDir, zos, "");
                                    zos.close();
                                    baos.close();
                                }
                                catch (Exception exception) {
                                    final File logLocation = new File(this.tempDir.getAbsolutePath(), MultiOperation.LOGS_ZIP);
                                    if (!logLocation.exists()) break block22;
                                    PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                                        public void run() {
                                            AntErrorDialog dialog = new AntErrorDialog(logLocation);
                                            dialog.open();
                                        }
                                    });
                                }
                            }
                            this.tempDir.delete();
                            is = new ByteArrayInputStream(baos.toByteArray());
                        }
                        ByteArrayOutputStream bos = new ByteArrayOutputStream();
                        statusCode = client.call(MultiOperation.this.getParameters(), is, bos);
                        if (statusCode == 200) break block23;
                        String error = bos.toString().replaceAll("( ){2,}", "\n\n");
                        status = new Status(4, PLUGIN_ID, error);
                        if (is == null) break block24;
                        try {
                            is.close();
                        }
                        catch (IOException iOException) {}
                    }
                    return status;
                }
                try {
                    System.out.println(String.valueOf(Messages.MultiOperation_status) + statusCode);
                }
                catch (HttpException e) {
                    Status status = new Status(4, PLUGIN_ID, e.getLocalizedMessage(), (Throwable)e);
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException iOException) {}
                    }
                    return status;
                }
                catch (IOException e) {
                    Status status;
                    block25: {
                        try {
                            status = new Status(4, PLUGIN_ID, e.getLocalizedMessage(), (Throwable)e);
                            if (is == null) break block25;
                        }
                        catch (Throwable throwable) {
                            if (is != null) {
                                try {
                                    is.close();
                                }
                                catch (IOException iOException) {}
                            }
                            throw throwable;
                        }
                        try {
                            is.close();
                        }
                        catch (IOException iOException) {}
                    }
                    return status;
                }
                if (is == null) break block26;
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
            return Status.OK_STATUS;
        }
    }
}

