/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swordfish.tutorial.discovery.commands;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Properties;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.internal.p2.discovery.Catalog;
import org.eclipse.equinox.internal.p2.discovery.DiscoveryCore;
import org.eclipse.equinox.internal.p2.discovery.compatibility.BundleDiscoveryStrategy;
import org.eclipse.equinox.internal.p2.discovery.compatibility.RemoteBundleDiscoveryStrategy;
import org.eclipse.equinox.internal.p2.discovery.model.Tag;
import org.eclipse.equinox.internal.p2.ui.discovery.util.WorkbenchUtil;
import org.eclipse.equinox.internal.p2.ui.discovery.wizards.CatalogConfiguration;
import org.eclipse.equinox.internal.p2.ui.discovery.wizards.DiscoveryWizard;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swordfish.tutorial.discovery.commands.Messages;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.intro.IIntroSite;
import org.eclipse.ui.intro.config.IIntroAction;
import org.osgi.framework.Bundle;

public class OpenTutorialDiscoveryDialogCommandHandler
extends AbstractHandler
implements IIntroAction {
    private static final String BUNDLE_ID = "org.eclipse.swordfish.tutorial.discovery";
    private static final String PROPERTY_FILE_NAME = "org/eclipse/swordfish/tutorial/discovery/commands/OpenTutorialDiscoveryDialogCommandHandler.properties";
    private static final String PROPERTY_KEY_DIRECTORY_URL = "org.eclipse.soa.discovery.directory.url";
    private static final String P2_INSTALL_UI_ID = "org.eclipse.equinox.p2.ui.sdk/org.eclipse.equinox.p2.ui.sdk.install";
    public static Tag TAG_FREE = new Tag("free", Messages.OpenTutorialDiscoveryDialogCommandHandler_Tag_Free);
    public static Tag TAG_REGISTRATION = new Tag("registration", Messages.OpenTutorialDiscoveryDialogCommandHandler_Tag_Registration);
    public static final Tag[] TAGS = new Tag[]{TAG_FREE, TAG_REGISTRATION};

    private String fetchDirectoryUrl() throws ExecutionException {
        String directoryUrl = System.getProperty(PROPERTY_KEY_DIRECTORY_URL);
        if (directoryUrl != null) {
            return directoryUrl;
        }
        Properties props = new Properties();
        try {
            Bundle myBundle = Platform.getBundle((String)BUNDLE_ID);
            URL myBundleUrl = myBundle.getResource(PROPERTY_FILE_NAME);
            InputStream in = myBundleUrl.openStream();
            props.load(in);
        }
        catch (NullPointerException npe) {
            String msg = NLS.bind((String)Messages.OpenTutorialDiscoveryDialogCommandHandler_UnableToLaunch_NoResource, (Object)PROPERTY_FILE_NAME, (Object)BUNDLE_ID);
            MessageDialog.openError((Shell)WorkbenchUtil.getShell(), (String)Messages.OpenTutorialDiscoveryDialogCommandHandler_InstallTutorials, (String)msg);
            throw new ExecutionException(msg, (Throwable)npe);
        }
        catch (IOException iox) {
            String msg = NLS.bind((String)Messages.OpenTutorialDiscoveryDialogCommandHandler_UnableToLaunch_NoResource, (Object)PROPERTY_FILE_NAME, (Object)BUNDLE_ID);
            MessageDialog.openError((Shell)WorkbenchUtil.getShell(), (String)Messages.OpenTutorialDiscoveryDialogCommandHandler_InstallTutorials, (String)msg);
            throw new ExecutionException(msg, (Throwable)iox);
        }
        directoryUrl = props.getProperty(PROPERTY_KEY_DIRECTORY_URL);
        if (directoryUrl == null) {
            MessageDialog.openError((Shell)WorkbenchUtil.getShell(), (String)Messages.OpenTutorialDiscoveryDialogCommandHandler_InstallTutorials, (String)Messages.OpenTutorialDiscoveryDialogCommandHandler_UnableToLaunch_NoDirectoryUrl);
            throw new ExecutionException(Messages.OpenTutorialDiscoveryDialogCommandHandler_UnableToLaunch_NoDirectoryUrl);
        }
        return directoryUrl;
    }

    private void openDialog() throws ExecutionException {
        Catalog catalog;
        if (WorkbenchUtil.allowUseOf((Object)P2_INSTALL_UI_ID)) {
            catalog = new Catalog();
            catalog.setTags(Arrays.asList(TAGS));
            catalog.getDiscoveryStrategies().add(new BundleDiscoveryStrategy());
            String directoryUrl = this.fetchDirectoryUrl();
            if (directoryUrl.length() > 0) {
                RemoteBundleDiscoveryStrategy remoteDiscoveryStrategy = new RemoteBundleDiscoveryStrategy();
                remoteDiscoveryStrategy.setDirectoryUrl(directoryUrl);
                catalog.getDiscoveryStrategies().add(remoteDiscoveryStrategy);
            }
        } else {
            MessageDialog.openError((Shell)WorkbenchUtil.getShell(), (String)Messages.OpenTutorialDiscoveryDialogCommandHandler_InstallTutorials, (String)Messages.OpenTutorialDiscoveryDialogCommandHandler_UnableToLaunch_NoP2);
            throw new ExecutionException(Messages.OpenTutorialDiscoveryDialogCommandHandler_UnableToLaunch_NoP2);
        }
        catalog.setEnvironment(DiscoveryCore.createEnvironment());
        catalog.setVerifyUpdateSiteAvailability(false);
        CatalogConfiguration configuration = new CatalogConfiguration();
        configuration.setSelectedTags((Collection)catalog.getTags());
        configuration.setShowCategories(true);
        configuration.setShowInstalled(true);
        configuration.setShowInstalledFilter(true);
        configuration.setShowTagFilter(false);
        configuration.setShowTextFilter(true);
        configuration.setVerifyUpdateSiteAvailability(false);
        DiscoveryWizard wizard = new DiscoveryWizard(catalog, configuration);
        wizard.getCatalogPage().setTitle(Messages.TutorialDiscoveryWizardMainPage_Title);
        wizard.getCatalogPage().setDescription(Messages.TutorialDiscoveryWizardMainPage_Description);
        WizardDialog dialog = new WizardDialog(WorkbenchUtil.getShell(), (IWizard)wizard);
        dialog.setHelpAvailable(false);
        dialog.open();
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.openDialog();
        return null;
    }

    public void run(IIntroSite site, Properties params) {
        try {
            this.openDialog();
        }
        catch (ExecutionException executionException) {}
    }
}

