/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swordfish.tutorial.registration.ui;

import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swordfish.tutorial.registration.Activator;
import org.eclipse.swordfish.tutorial.registration.Messages;
import org.eclipse.swordfish.tutorial.registration.ui.RegistrationDialogData;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.osgi.framework.Bundle;

public class RegistrationDialog
extends TitleAreaDialog
implements ModifyListener {
    private static final String PROPERTY_FILE_NAME = "org/eclipse/swordfish/tutorial/registration/ui/RegistrationDialog.properties";
    private static final String PROPERTY_KEY_REGISTRATION_URL = "org.eclipse.swordfish.tutorial.registration.url";
    private static final String UTF_8 = "UTF-8";
    private static final String TITLE = Messages.RegistrationDialog_WindowTitle;
    private static final Pattern emailPattern = Pattern.compile("^[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?$");
    private static final int TEXTFIELD_LENGTH_LIMIT = 250;
    private Text userNameText;
    private Text emailText;
    private Text phoneText;
    private Text companyText;
    private Text countryText;
    private Button contactCheck;
    private Button notifyCheck;
    private RegistrationDialogData data;

    public RegistrationDialog(Shell parent) {
        super(parent);
        this.setTitleImage(Activator.getImageDescriptor("icons/sopera.gif").createImage());
        this.data = new RegistrationDialogData();
    }

    private String fetchRegistrationUrl() {
        String registrationUrl = System.getProperty(PROPERTY_KEY_REGISTRATION_URL);
        if (registrationUrl != null && registrationUrl.length() > 0) {
            return registrationUrl;
        }
        Properties props = new Properties();
        try {
            Bundle myBundle = Platform.getBundle((String)Activator.getPluginId());
            URL myBundleUrl = myBundle.getResource(PROPERTY_FILE_NAME);
            InputStream in = myBundleUrl.openStream();
            props.load(in);
        }
        catch (Exception e) {
            this.updateStatus(NLS.bind((String)Messages.RegistrationDialog_Error_NoUrlResource, (Object)e.getLocalizedMessage()));
        }
        registrationUrl = props.getProperty(PROPERTY_KEY_REGISTRATION_URL);
        return registrationUrl;
    }

    private Text createText(Composite composite, String text) {
        Label label = new Label(composite, 0);
        label.setText(text);
        Text result = new Text(composite, 2052);
        result.setText(Messages.RegistrationDialog_empty);
        result.setTextLimit(250);
        result.setLayoutData((Object)new GridData(768));
        result.addModifyListener((ModifyListener)this);
        return result;
    }

    private Button createCheckbox(Composite composite, String text) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        composite2.setLayout((Layout)layout);
        GridData layoutData = new GridData(4, 0, true, false, 2, 1);
        layoutData.widthHint = 220;
        composite2.setLayoutData((Object)layoutData);
        final Button checkbox = new Button(composite2, 32);
        checkbox.setSelection(true);
        checkbox.setText(Messages.RegistrationDialog_empty);
        Label commentNotify = new Label(composite2, 64);
        commentNotify.setText(text);
        commentNotify.setLayoutData((Object)new GridData(768));
        commentNotify.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                checkbox.setSelection(!checkbox.getSelection());
            }
        });
        return checkbox;
    }

    private boolean doValidate() {
        Matcher matcher;
        StringBuilder sb = new StringBuilder();
        if (this.isEmpty(this.userNameText)) {
            sb.append(Messages.RegistrationDialog_Error_UsernameEmpty);
        }
        if (this.isEmpty(this.emailText)) {
            sb.append(Messages.RegistrationDialog_Error_EmailEmpty);
        }
        if (!(matcher = emailPattern.matcher(this.emailText.getText())).matches()) {
            sb.append(Messages.RegistrationDialog_Error_EmailNotValid);
        }
        boolean valid = sb.length() == 0;
        this.updateStatus(valid ? null : sb.toString());
        return valid;
    }

    private boolean isEmpty(Text text) {
        return text.getText() != null && text.getText().trim().length() == 0;
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.getButton(0).setEnabled(message == null);
    }

    protected Control createContents(Composite parent) {
        Control value = super.createContents(parent);
        this.getButton(0).setEnabled(false);
        return value;
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x10 | 0x860 | 0x10000);
    }

    protected Control createDialogArea(Composite parent) {
        Control dialogArea = super.createDialogArea(parent);
        this.getShell().setText(TITLE);
        this.setTitle(TITLE);
        Composite composite = new Composite((Composite)dialogArea, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(1808));
        Label h2 = new Label(composite, 0);
        h2.setText(Messages.RegistrationDialog_Subheader);
        h2.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
        FontData[] fd = h2.getFont().getFontData();
        fd[0].height = fd[0].getHeight() + 2;
        fd[0].setStyle(1);
        Font h2Font = new Font((Device)Display.getCurrent(), fd[0]);
        h2.setFont(h2Font);
        Label comment = new Label(composite, 64);
        comment.setText(Messages.RegistrationDialog_WindowText);
        GridData layoutData = new GridData(4, 0, true, false, 2, 1);
        layoutData.widthHint = 200;
        comment.setLayoutData((Object)layoutData);
        this.userNameText = this.createText(composite, Messages.RegistrationDialog_username);
        this.emailText = this.createText(composite, Messages.RegistrationDialog_email);
        this.phoneText = this.createText(composite, Messages.RegistrationDialog_phone);
        this.companyText = this.createText(composite, Messages.RegistrationDialog_company);
        this.countryText = this.createText(composite, Messages.RegistrationDialog_country);
        this.notifyCheck = this.createCheckbox(composite, Messages.RegistrationDialog_notifyMe);
        this.contactCheck = this.createCheckbox(composite, Messages.RegistrationDialog_contactMe);
        return dialogArea;
    }

    protected void cancelPressed() {
        this.data.setRegistrationStatus(new Status(8, Activator.getPluginId(), Messages.RegistrationDialog_RegistrationCanceled));
        super.cancelPressed();
    }

    protected void okPressed() {
        String userName = this.userNameText.getText().trim();
        String email = this.emailText.getText().trim();
        this.data.setUserName(userName);
        this.data.setEmail(email);
        this.data.setPhone(this.phoneText.getText());
        this.data.setCompany(this.companyText.getText());
        this.data.setCountry(this.countryText.getText());
        this.data.setNotifyCheck(this.notifyCheck.getSelection());
        this.data.setContactCheck(this.contactCheck.getSelection());
        HttpClient client = new HttpClient();
        PutMethod method = null;
        try {
            try {
                String url = this.fetchRegistrationUrl();
                if (url == null || url.length() == 0) {
                    throw new IllegalStateException(Messages.RegistrationDialog_Error_NoUrl);
                }
                String uri = url + System.currentTimeMillis() + Math.abs((String.valueOf(userName) + email).hashCode()) + ".properties";
                method = new PutMethod(uri);
                method.setRequestEntity((RequestEntity)new StringRequestEntity(this.data.toString(), null, UTF_8));
                client.executeMethod((HttpMethod)method);
                super.okPressed();
                this.data.setRegistrationStatus(new Status(0, Activator.getPluginId(), Messages.RegistrationDialog_RegistrationSuccessful));
            }
            catch (Exception e) {
                this.data.setRegistrationStatus(new Status(4, Activator.getPluginId(), String.valueOf(Messages.RegistrationDialog_RegistrationError) + ": " + e.getLocalizedMessage()));
                this.updateStatus(e.getLocalizedMessage());
                if (method != null) {
                    method.releaseConnection();
                }
            }
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    public void modifyText(ModifyEvent e) {
        this.doValidate();
    }

    public RegistrationDialogData getData() {
        return this.data;
    }
}

