/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.discovery.model;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.UnknownHostException;
import org.eclipse.core.internal.registry.ExtensionRegistry;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.spi.RegistryStrategy;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.discovery.model.AbstractDiscoverySource;
import org.eclipse.team.svn.core.discovery.model.BundleDiscoveryStrategy;
import org.eclipse.team.svn.core.discovery.model.DiscoveryRegistryStrategy;
import org.eclipse.team.svn.core.discovery.model.JarDiscoverySource;
import org.eclipse.team.svn.core.discovery.util.WebUtil;
import org.eclipse.team.svn.core.operation.LoggedOperation;

public class RemoteBundleDiscoveryStrategy
extends BundleDiscoveryStrategy {
    private String discoveryUrl;
    private DiscoveryRegistryStrategy registryStrategy;
    private File temporaryStorage;
    private int maxDiscoveryJarDownloadAttempts = 1;

    public void performDiscovery(IProgressMonitor monitor) throws CoreException {
        if (this.connectors == null || this.categories == null || this.discoveryUrl == null) {
            throw new IllegalStateException();
        }
        if (this.registryStrategy != null) {
            throw new IllegalStateException();
        }
        monitor.beginTask(SVNMessages.RemoteBundleDiscoveryStrategy_task_remote_discovery, 100000);
        try {
            File registryCacheFolder;
            try {
                if (this.temporaryStorage != null && this.temporaryStorage.exists()) {
                    this.delete(this.temporaryStorage);
                }
                this.temporaryStorage = File.createTempFile(RemoteBundleDiscoveryStrategy.class.getSimpleName(), ".tmp");
                this.temporaryStorage.delete();
                if (!this.temporaryStorage.mkdirs()) {
                    throw new IOException();
                }
                registryCacheFolder = new File(this.temporaryStorage, ".rcache");
                if (!registryCacheFolder.mkdirs()) {
                    throw new IOException();
                }
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.team.svn.core.svnnature", SVNMessages.RemoteBundleDiscoveryStrategy_io_failure_temp_storage, (Throwable)e));
            }
            if (monitor.isCanceled()) {
                return;
            }
            DownloadBundleJob downloadBundleJob = new DownloadBundleJob(this.discoveryUrl, monitor);
            downloadBundleJob.exec();
            File bundleFile = downloadBundleJob.getFile();
            try {
                this.registryStrategy = new DiscoveryRegistryStrategy(new File[]{registryCacheFolder}, new boolean[1], this);
                this.registryStrategy.setDiscoveryInfo(bundleFile, this.discoveryUrl);
                ExtensionRegistry extensionRegistry = new ExtensionRegistry((RegistryStrategy)this.registryStrategy, (Object)this, (Object)this);
                try {
                    IExtension[] extensions;
                    IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint("org.eclipse.team.svn.core.connectorDiscovery");
                    if (extensionPoint != null && (extensions = extensionPoint.getExtensions()).length > 0) {
                        this.processExtensions((IProgressMonitor)new SubProgressMonitor(monitor, 30000), extensions);
                    }
                }
                finally {
                    extensionRegistry.stop((Object)this);
                }
            }
            finally {
                this.registryStrategy = null;
            }
        }
        finally {
            monitor.done();
        }
    }

    private boolean isUnknownHostException(Throwable t) {
        while (t != null) {
            if (t instanceof UnknownHostException) {
                return true;
            }
            Throwable t2 = t.getCause();
            if (t2 == t) break;
            t = t2;
        }
        return false;
    }

    private void delete(File file) {
        if (file.exists()) {
            File[] children;
            if (file.isDirectory() && (children = file.listFiles()) != null) {
                File[] fileArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    File child = fileArray[n2];
                    this.delete(child);
                    ++n2;
                }
            }
            file.delete();
        }
    }

    public void dispose() {
        super.dispose();
        if (this.temporaryStorage != null) {
            this.delete(this.temporaryStorage);
        }
    }

    public void setDiscoveryUrl(String discoveryUrl) {
        this.discoveryUrl = discoveryUrl;
    }

    protected AbstractDiscoverySource computeDiscoverySource(IContributor contributor) {
        JarDiscoverySource discoverySource = new JarDiscoverySource(contributor.getName(), this.registryStrategy.getJarFile(contributor));
        return discoverySource;
    }

    public int getMaxDiscoveryJarDownloadAttempts() {
        return this.maxDiscoveryJarDownloadAttempts;
    }

    public void setMaxDiscoveryJarDownloadAttempts(int maxDiscoveryJarDownloadAttempts) {
        if (maxDiscoveryJarDownloadAttempts < 1 || maxDiscoveryJarDownloadAttempts > 2) {
            throw new IllegalArgumentException();
        }
        this.maxDiscoveryJarDownloadAttempts = maxDiscoveryJarDownloadAttempts;
    }

    private class DownloadBundleJob {
        private final IProgressMonitor monitor;
        private final String location;
        private File file;

        public DownloadBundleJob(String location, IProgressMonitor monitor) {
            this.location = location;
            this.monitor = monitor;
        }

        public void exec() {
            String bundleUrl = this.location;
            int attemptCount = 0;
            while (attemptCount < RemoteBundleDiscoveryStrategy.this.maxDiscoveryJarDownloadAttempts) {
                try {
                    if (!bundleUrl.startsWith("http://") && !bundleUrl.startsWith("https://")) {
                        String errMessage = SVNMessages.format(SVNMessages.RemoteBundleDiscoveryStrategy_unrecognized_discovery_url, bundleUrl);
                        LoggedOperation.reportError(this.getClass().getName(), new Exception(errMessage));
                    } else {
                        String lastPathElement = bundleUrl.lastIndexOf(47) == -1 ? bundleUrl : bundleUrl.substring(bundleUrl.lastIndexOf(47));
                        File target = File.createTempFile(String.valueOf(lastPathElement.replaceAll("^[a-zA-Z0-9_.]", "_")) + "_", ".jar", RemoteBundleDiscoveryStrategy.this.temporaryStorage);
                        if (this.monitor.isCanceled()) break;
                        WebUtil.downloadResource(target, new URL(bundleUrl), (IProgressMonitor)new NullProgressMonitor(){

                            public boolean isCanceled() {
                                return super.isCanceled() || DownloadBundleJob.this.monitor.isCanceled();
                            }
                        });
                        this.file = target;
                    }
                }
                catch (IOException e) {
                    String errMessage = SVNMessages.format(SVNMessages.RemoteBundleDiscoveryStrategy_cannot_download_bundle, bundleUrl);
                    LoggedOperation.reportError(this.getClass().getName(), new Exception(errMessage, e));
                    if (RemoteBundleDiscoveryStrategy.this.isUnknownHostException(e)) break;
                }
                ++attemptCount;
            }
        }

        public File getFile() {
            return this.file;
        }
    }
}

