/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.local;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.SVNConnectorUnresolvedConflictException;
import org.eclipse.team.svn.core.extension.CoreExtensionsManager;
import org.eclipse.team.svn.core.operation.IRevisionProvider;
import org.eclipse.team.svn.core.operation.IUnprotectedOperation;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.operation.local.AbstractConflictDetectionOperation;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IResourceProvider;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;

public class CommitOperation
extends AbstractConflictDetectionOperation
implements IRevisionProvider {
    protected boolean recursive;
    protected boolean keepLocks;
    protected String message;
    protected ArrayList<IRevisionProvider.RevisionPair> revisionsPairs;
    protected String[] paths;

    public CommitOperation(IResource[] resources, String message, boolean recursive, boolean keepLocks) {
        super("Operation_Commit", SVNMessages.class, resources);
        this.message = message;
        this.recursive = recursive;
        this.keepLocks = keepLocks;
    }

    public CommitOperation(IResource[] resources, String message, boolean recursive) {
        this(resources, message, recursive, false);
    }

    public CommitOperation(IResourceProvider provider, String message, boolean recursive, boolean keepLocks) {
        super("Operation_Commit", SVNMessages.class, provider);
        this.message = message;
        this.recursive = recursive;
        this.keepLocks = keepLocks;
    }

    public CommitOperation(IResourceProvider provider, String message, boolean recursive) {
        this(provider, message, recursive, false);
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        this.revisionsPairs = new ArrayList();
        IResource[] resources = this.operableData();
        this.defineInitialResourceSet(resources);
        if (this.recursive) {
            resources = FileUtility.shrinkChildNodesWithSwitched(resources);
        } else {
            FileUtility.reorder(resources, true);
        }
        if ((CoreExtensionsManager.instance().getSVNConnectorFactory().getSupportedFeatures() & 4) != 0) {
            Map proxy2Resources = SVNUtility.splitRepositoryLocations(resources);
            Iterator it = proxy2Resources.entrySet().iterator();
            while (it.hasNext() && !monitor.isCanceled()) {
                Map.Entry entry = it.next();
                IRepositoryLocation location = (IRepositoryLocation)entry.getKey();
                this.performCommit(location, (List)entry.getValue(), monitor, proxy2Resources.size());
            }
        } else {
            Map<IProject, List<IResource>> project2Resources = SVNUtility.splitWorkingCopies(resources);
            SVNRemoteStorage storage = SVNRemoteStorage.instance();
            Iterator<Map.Entry<IProject, List<IResource>>> it = project2Resources.entrySet().iterator();
            while (it.hasNext() && !monitor.isCanceled()) {
                Map.Entry<IProject, List<IResource>> entry = it.next();
                IRepositoryLocation location = storage.getRepositoryLocation((IResource)entry.getKey());
                this.performCommit(location, entry.getValue(), monitor, project2Resources.size());
            }
        }
    }

    protected void performCommit(final IRepositoryLocation location, List resources, final IProgressMonitor monitor, int total) {
        this.paths = FileUtility.asPathArray(resources.toArray(new IResource[0]));
        this.complexWriteToConsole(new Runnable(){

            public void run() {
                CommitOperation.this.writeToConsole(0, "svn commit");
                int i = 0;
                while (i < CommitOperation.this.paths.length && !monitor.isCanceled()) {
                    CommitOperation.this.writeToConsole(0, " \"" + CommitOperation.this.paths[i] + "\"");
                    ++i;
                }
                CommitOperation.this.writeToConsole(0, String.valueOf(CommitOperation.this.recursive ? "" : " -N") + (CommitOperation.this.keepLocks ? " --no-unlock" : "") + " -m \"" + CommitOperation.this.message + "\"" + FileUtility.getUsernameParam(location.getUsername()) + "\n");
            }
        });
        final ISVNConnector proxy = location.acquireSVNProxy();
        this.protectStep(new IUnprotectedOperation(){

            public void run(IProgressMonitor monitor) throws Exception {
                long[] revisionNumbers = proxy.commit(CommitOperation.this.paths, CommitOperation.this.message, null, ISVNConnector.Depth.infinityOrEmpty(CommitOperation.this.recursive), CommitOperation.this.keepLocks ? 16L : 0L, null, new SVNProgressMonitor(CommitOperation.this, monitor, null));
                if (revisionNumbers.length > 0) {
                    CommitOperation.this.revisionsPairs.add(new IRevisionProvider.RevisionPair(revisionNumbers[0], CommitOperation.this.paths, location));
                    String message = SVNMessages.format(SVNMessages.Console_CommittedRevision, new String[]{String.valueOf(revisionNumbers[0])});
                    CommitOperation.this.writeToConsole(1, message);
                }
            }
        }, monitor, total);
        location.releaseSVNProxy(proxy);
    }

    public IRevisionProvider.RevisionPair[] getRevisions() {
        return this.revisionsPairs == null ? null : this.revisionsPairs.toArray(new IRevisionProvider.RevisionPair[this.revisionsPairs.size()]);
    }

    protected void reportError(Throwable t) {
        if (t instanceof SVNConnectorUnresolvedConflictException) {
            SVNConnectorUnresolvedConflictException ex;
            this.setUnresolvedConflict(true);
            StringBuffer message = new StringBuffer();
            if (t.getMessage() != null && t.getMessage().length() > 0) {
                message.append(t.getMessage());
            }
            if ((ex = (SVNConnectorUnresolvedConflictException)t).getErrorId() == 160024) {
                message.append(message.toString().endsWith("\n") ? "\n" : "\n\n");
                message.append(SVNMessages.CommitOperation_3);
            }
            this.setConflictMessage(message.toString());
            int i = 0;
            while (i < this.paths.length) {
                IResource[] iResourceArray = this.getProcessed();
                int n = iResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource res = iResourceArray[n2];
                    if (FileUtility.getResourcePath(res).equals((Object)new Path(this.paths[i]))) {
                        this.removeProcessed(res);
                        this.addUnprocessed(res);
                        break;
                    }
                    ++n2;
                }
                ++i;
            }
        } else {
            super.reportError(t);
        }
    }
}

